% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupci.R
\name{groupci}
\alias{groupci}
\title{Assess Calibration for a Competing Risks Endpoint}
\usage{
groupci(
  x,
  ftime,
  fstatus,
  u,
  cencode = 0,
  failcode = 1,
  ci = TRUE,
  m = 50,
  g = NULL,
  cuts = NULL,
  pl = TRUE,
  conf.int = 0.95,
  xlab = NULL,
  ylab = NULL,
  xlim = c(0, 1),
  ylim = c(0, 1),
  lty = 1,
  add = FALSE,
  cex.subtitle = FALSE,
  ab = TRUE,
  a = 0,
  b = 1,
  ...
)
}
\arguments{
\item{x}{A numeric variable to assess calibration for}

\item{ftime}{The event time variable. See \code{\link[cmprsk]{cuminc}}.}

\item{fstatus}{The event status variable. See \code{\link[cmprsk]{cuminc}}.}

\item{u}{A single time point to assess calibration at}

\item{cencode}{The censoring event code. See \code{\link[cmprsk]{cuminc}}.}

\item{failcode}{The value of \code{fstatus} that indicates the event of interest}

\item{ci}{Should the failure probability be assessed? Defaults to \code{TRUE}. If \code{FALSE}, the event-free probability is assessed.}

\item{m}{Minimum number of observations in each group. See \code{\link[Hmisc]{cut2}}.}

\item{g}{Number of quantile groups. See \code{\link[Hmisc]{cut2}}.}

\item{cuts}{Actual cut points to use for \code{x}. See \code{\link[Hmisc]{cut2}}.}

\item{pl}{Should the calibration curve be plotted? Defaults to \code{TRUE}.}

\item{conf.int}{Confidence limit on error bars. Defaults to 0.95. Set to \code{FALSE} to suppress.}

\item{xlab}{The x-axis label. Uses \code{\link[Hmisc]{label}} or name of calling argument if not specified.}

\item{ylab}{The y-axis label. Uses a default label is none specified.}

\item{xlim}{The x-axis limits. Defaults to c(0, 1).}

\item{ylim}{The y-axis limits. Defaults to c(0, 1).}

\item{lty}{Line type for connecting estimates and error bars}

\item{add}{Defaults to \code{FALSE}. Set to \code{TRUE} to add to an existing plot.}

\item{cex.subtitle}{Character size for subtitle (default 0.7). Defaults to \code{FALSE} to suppress.}

\item{ab}{Should a reference line be added? See \code{\link[graphics]{abline}}.}

\item{a}{The intercept for the reference line. See \code{\link[graphics]{abline}}.}

\item{b}{The slope for the reference line. See \code{\link[graphics]{abline}}.}

\item{...}{Other arguments passed to \code{\link[graphics]{lines}} and \code{\link[Hmisc]{errbar}}.}
}
\value{
A matrix with a row for each group of \code{x}:
\item{x}{Mean value of \code{x}}
\item{n}{Number of observations}
\item{events}{Number of events (of type \code{failcode})}
\item{ci}{Estimated cumulative incidence (or event-free probability if \code{ci=FALSE})}
\item{std.err}{Estimated standard error for the \code{ci} value}
If \code{pl=TRUE}, a calibration plot is also displayed.
}
\description{
Uses \code{\link[cmprsk]{cuminc}} to estimate the cumulative incidence at a given time point within subgroups of a continuous variable (often predicted failure probabilities from a \code{\link[QHScrnomo]{crr.fit}} model).
}
\details{
To divide \code{x}, the function first looks for \code{cuts}, then \code{g}, then \code{m}.
}
\examples{
dd <- datadist(prostate.dat)
options(datadist = "dd")
prostate.f <- cph(Surv(TIME_EVENT,EVENT_DOD == 1) ~ TX  + rcs(PSA,3) +
           BX_GLSN_CAT +  CLIN_STG + rcs(AGE,3) +
           RACE_AA, data = prostate.dat,
           x = TRUE, y = TRUE, surv = TRUE,time.inc = 144)
prostate.crr <- crr.fit(prostate.f, cencode = 0, failcode = 1)

# Cross-validated predictions
prostate.dat$preds.cv.prostate.crr.120 <- tenf.crr(prostate.crr, time = 120, fold = 2)

with(prostate.dat,
     groupci(preds.cv.prostate.crr.120, ftime = TIME_EVENT,
             fstatus =EVENT_DOD, g = 5, u = 120,
             xlab = "Nomogram predicted 10-year cancerspecific mortality",
             ylab = "Observed predicted 10-year cancerspecific mortality")
)

}
\seealso{
\code{\link[cmprsk]{cuminc}} \code{\link[QHScrnomo]{pred.ci}} \code{\link[Hmisc]{cut2}}
}
\author{
Changhong Yu, Michael Kattan, Ph.D \cr Department of Quantitative Health Sciences\cr Cleveland Clinic\cr
}
\keyword{nonparametric}
\keyword{survival}
