% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wop_inter.R
\name{wop_inter}
\alias{wop_inter}
\title{Calculation of weight of partitions in pooled solution parameters
for intermediate solution}
\usage{
wop_inter(
  dataset,
  units,
  time,
  cond,
  out,
  n_cut,
  incl_cut,
  intermediate,
  amb_selector
)
}
\arguments{
\item{dataset}{Calibrated pooled dataset for partitioning and minimization}

\item{units}{Units defining the within-dimension of data (time series)}

\item{time}{Periods defining the between-dimension of data (cross sections)}

\item{cond}{Conditions used for the pooled analysis}

\item{out}{Outcome used for the pooled analysis}

\item{n_cut}{Frequency cut-off for designating truth table rows as observed}

\item{incl_cut}{Inclusion cut-off for designating truth table rows as
consistent}

\item{intermediate}{A vector of directional expectations to derive the
intermediate solutions}

\item{amb_selector}{Numerical value for selecting a single model in the
presence of model ambiguity. Models are numbered according to their
order produced by \code{\link{minimize}} by the \code{QCA} package.}
}
\value{
A dataframe with information about the weight of the partitions
for pooled consistency and coverage scores and the following columns:
\itemize{
\item \code{type}: The type of the partition. \code{between} stands for
cross-sections; \code{within} stands for time series. \code{pooled} stands
information about the pooled data.
\item \code{partition}: Type of partition. For
between-dimension, the unit identifiers are listed  (argument \code{units}).
For the within-dimension, the time identifiers are listed (argument \code{time}).
The entry is \code{-} for the pooled data.
\item \code{denom_cons}: Denominator of the consistency formula. It is the sum
over the cases' membership in the solution.
\item \code{num_cons}: Numerator of the consistency formula. It is the sum
over the minimum of the cases' membership in the solution and the outcome.
\item \code{denom_cov}: Denominator of the coverage formula. It is the sum
over the cases' membership in the outcome.
\item \code{num_cov}: Numerator of the coverage formula. It is the sum
over the minimum of the cases' membership in the solution and the outcome.
(identical to \code{num_cons})
}
}
\description{
\code{wop_inter} calculates the weight of partitions in the pooled
solution parameters (consistency, coverage) for the intermediate solution.
}
\examples{
data(Schwarz2016)

}
