% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qbms.R
\name{calc_biovars}
\alias{calc_biovars}
\title{Calculate the Bioclimatic Variables}
\usage{
calc_biovars(data)
}
\arguments{
\item{data}{Data.frame has 4 mandatory columns (year, ppt, tmin, and tmax), 
and 12 rows (months) for each year sorted from Jan to Dec.}
}
\value{
Data.frame has 19 columns for "bioclim" variables (bio1-bio19) and 
        last column for year (you will get one row per year).
}
\description{
Bioclimatic variables are derived from the monthly temperature and rainfall 
values in order to generate more biologically meaningful variables. These are 
often used in species distribution modeling and related ecological modeling 
techniques. The bioclimatic variables represent annual trends (e.g., mean 
annual temperature, annual precipitation) seasonality (e.g., annual range in 
temperature and precipitation) and extreme or limiting environmental factors 
(e.g., temperature of the coldest and warmest month, and precipitation of the 
wet and dry quarters). A quarter is a period of three months (1/4 of the year).

They are coded as follows:
\itemize{
\item BIO1 = Annual Mean Temperature
\item BIO2 = Mean Diurnal Range (Mean of monthly (max temp - min temp))
\item BIO3 = Isothermality (BIO2/BIO7) (* 100)
\item BIO4 = Temperature Seasonality (standard deviation *100)
\item BIO5 = Max Temperature of Warmest Month
\item BIO6 = Min Temperature of Coldest Month
\item BIO7 = Temperature Annual Range (BIO5-BIO6)
\item BIO8 = Mean Temperature of Wettest Quarter
\item BIO9 = Mean Temperature of Driest Quarter
\item BIO10 = Mean Temperature of Warmest Quarter
\item BIO11 = Mean Temperature of Coldest Quarter
\item BIO12 = Annual Precipitation
\item BIO13 = Precipitation of Wettest Month
\item BIO14 = Precipitation of Driest Month
\item BIO15 = Precipitation Seasonality (Coefficient of Variation)
\item BIO16 = Precipitation of Wettest Quarter
\item BIO17 = Precipitation of Driest Quarter
\item BIO18 = Precipitation of Warmest Quarter
\item BIO19 = Precipitation of Coldest Quarter
}
     
This work is derivative from the \href{https://github.com/rspatial/dismo/blob/master/R/biovars.R}{dismo R package}
}
\references{
Nix, 1986. A biogeographic analysis of Australian elapid snakes. 
            In: R. Longmore (ed.). Atlas of elapid snakes of Australia. 
            Australian Flora and Fauna Series 7. Australian Government Publishing 
            Service, Canberra.
}
\author{
Khaled Al-Shamaa, \email{k.el-shamaa@cgiar.org}

Robert Hijmans, Museum of Vertebrate Zoology, UC Berkeley
}
