% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-standard_curve.R
\name{plot_standard_curve_analyte}
\alias{plot_standard_curve_analyte}
\title{Standard curves}
\usage{
plot_standard_curve_analyte(
  plate,
  analyte_name,
  data_type = "Median",
  decreasing_rau_order = TRUE,
  log_scale = c("all"),
  plot_line = TRUE,
  plot_blank_mean = TRUE,
  plot_rau_bounds = TRUE,
  plot_legend = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{plate}{A plate object}

\item{analyte_name}{Name of the analyte of which standard curve we want to plot.}

\item{data_type}{Data type of the value we want to plot - the same datatype as in the plate file. By default equals to \verb{Net MFI}}

\item{decreasing_rau_order}{If \code{TRUE} the RAU values are plotted in decreasing order, \code{TRUE} by default}

\item{log_scale}{Which elements on the plot should be displayed in log scale. By default \code{"RAU"}. If \code{NULL} or \code{c()} no log scale is used, if \code{"all"} or \code{c("RAU", "MFI")} all elements are displayed in log scale.}

\item{plot_line}{If \code{TRUE} a line is plotted, \code{TRUE} by default}

\item{plot_blank_mean}{If \code{TRUE} the mean of the blank samples is plotted, \code{TRUE} by default}

\item{plot_rau_bounds}{If \code{TRUE} the RAU values bounds are plotted, \code{TRUE} by default}

\item{plot_legend}{If \code{TRUE} the legend is plotted, \code{TRUE} by default}

\item{verbose}{If \code{TRUE} prints messages, \code{TRUE} by default}
}
\value{
ggplot object with the plot
}
\description{
Plot standard curve samples of a plate of a given analyte.
}
