% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-basic.R
\name{plot_similarity}
\alias{plot_similarity}
\title{Visualize cosine similarity of word pairs.}
\usage{
plot_similarity(
  data,
  words = NULL,
  pattern = NULL,
  words1 = NULL,
  words2 = NULL,
  label = "auto",
  value.color = NULL,
  value.percent = FALSE,
  order = c("original", "AOE", "FPC", "hclust", "alphabet"),
  hclust.method = c("complete", "ward", "ward.D", "ward.D2", "single", "average",
    "mcquitty", "median", "centroid"),
  hclust.n = NULL,
  hclust.color = "black",
  hclust.line = 2,
  file = NULL,
  width = 10,
  height = 6,
  dpi = 500,
  ...
)
}
\arguments{
\item{data}{A \code{\link[PsychWordVec:as_wordvec]{wordvec}} (data.table) or
\code{\link[PsychWordVec:as_embed]{embed}} (matrix),
see \code{\link{data_wordvec_load}}.}

\item{words}{[Option 1] Character string(s).}

\item{pattern}{[Option 2] Regular expression (see \code{\link[stringr:str_subset]{str_subset}}).
If neither \code{words} nor \code{pattern} are specified (i.e., both are \code{NULL}),
then all words in the data will be extracted.}

\item{words1, words2}{[Option 3]
Two sets of words for only n1 * n2 word pairs. See examples.}

\item{label}{Position of text labels.
Defaults to \code{"auto"} (add labels if less than 20 words).
Can be \code{TRUE} (left and top), \code{FALSE} (add no labels of words),
or a character string (see the usage of \code{tl.pos} in \code{\link[corrplot:corrplot]{corrplot}}.}

\item{value.color}{Color of values added on the plot.
Defaults to \code{NULL} (add no values).}

\item{value.percent}{Whether to transform values into percentage style for space saving.
Defaults to \code{FALSE}.}

\item{order}{Character, the ordering method of the correlation matrix.
\itemize{
  \item{\code{'original'} for original order (default).}
  \item{\code{'AOE'} for the angular order of the eigenvectors.}
  \item{\code{'FPC'} for the first principal component order.}
  \item{\code{'hclust'} for the hierarchical clustering order.}
  \item{\code{'alphabet'} for alphabetical order.}
}

See function \code{\link[corrplot]{corrMatOrder}} for details.}

\item{hclust.method}{Character, the agglomeration method to be used when
\code{order} is \code{\link{hclust}}. This should be one of \code{'ward'},
\code{'ward.D'}, \code{'ward.D2'}, \code{'single'}, \code{'complete'},
\code{'average'}, \code{'mcquitty'}, \code{'median'} or \code{'centroid'}.}

\item{hclust.n}{Number of rectangles to be drawn on the plot according to
the hierarchical clusters, only valid when \code{order="hclust"}.
Defaults to \code{NULL} (add no rectangles).}

\item{hclust.color}{Color of rectangle border, only valid when \code{hclust.n} >= 1.
Defaults to \code{"black"}.}

\item{hclust.line}{Line width of rectangle border, only valid when \code{hclust.n} >= 1.
Defaults to \code{2}.}

\item{file}{File name to be saved, should be png or pdf.}

\item{width, height}{Width and height (in inches) for the saved file.
Defaults to \code{10} and \code{6}.}

\item{dpi}{Dots per inch. Defaults to \code{500} (i.e., file resolution: 4000 * 3000).}

\item{...}{Other parameters passed to \code{\link[corrplot:corrplot]{corrplot}}.}
}
\value{
Invisibly return a matrix of cosine similarity between each pair of words.
}
\description{
Visualize cosine similarity of word pairs.
}
\section{Download}{

Download pre-trained word vectors data (\code{.RData}):
\url{https://psychbruce.github.io/WordVector_RData.pdf}
}

\examples{
\donttest{w1 = cc("king, queen, man, woman")
plot_similarity(demodata, w1)
plot_similarity(demodata, w1,
                value.color="grey",
                value.percent=TRUE)
plot_similarity(demodata, w1,
                value.color="grey",
                order="hclust",
                hclust.n=2)

plot_similarity(
  demodata,
  words1=cc("man, woman, king, queen"),
  words2=cc("he, she, boy, girl, father, mother"),
  value.color="grey20"
)

w2 = cc("China, Chinese,
         Japan, Japanese,
         Korea, Korean,
         man, woman, boy, girl,
         good, bad, positive, negative")
plot_similarity(demodata, w2,
                order="hclust",
                hclust.n=3)
plot_similarity(demodata, w2,
                order="hclust",
                hclust.n=7,
                file="plot.png")

unlink("plot.png")  # delete file for code check
}
}
\seealso{
\code{\link{cosine_similarity}}

\code{\link{pair_similarity}}

\code{\link{tab_similarity}}

\code{\link{most_similar}}

\code{\link{plot_network}}
}
