% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r, R/06PTModule.r
\name{playSample}
\alias{playSample}
\alias{playSample,PTSample-method}
\alias{playSample,PTModule-method}
\title{Play audio samples}
\usage{
\S4method{playSample}{PTSample}(x, silence = 0, wait = T, note = "C-3", loop = 1, ...)

\S4method{playSample}{PTModule}(x, silence = 0, wait = T, note = "C-3", loop = 1, ...)
}
\arguments{
\item{x}{Either a \code{\link{PTSample}} or a \code{\link{PTModule}} object.
In the latter case, all samples in the module will be played in order.}

\item{silence}{Especially for short samples, the \code{\link[audio:play]{audio::play}} routine
can be a bit buggy: playing audible noise, ticks or parts from other samples at the end of the sample.
By adding silence after the sample, this problem is evaded. Use this argument
to specify the duration of this silence in seconds. When, \code{x} is a
\code{\link{PTModule}} object, the silence will also be inserted in
between samples.}

\item{wait}{A \code{logical} value. When set to \code{TRUE} the playing
routine will wait with executing any code until the playing is finished.
When set to \code{FALSE}, subsequent R code will be executed while playing.}

\item{note}{A \code{character} string specifying the note to be used for
calculating the playback sample rate (using \code{\link{noteToSampleRate}}).
It should start with the note (ranging from \verb{A' up to }G') optionally followed
by a hash sign (\verb{#') if a note is sharp (or a dash (}-') if it's not) and finally
the octave number (ranging from 1 up to 3). A valid notation would for instance
be 'F#3'.
The \code{\link{fineTune}} as specified for the sample will also be used as
an argument for calculating the playback rate. A custom \code{finetune}
can also be passed as an argument to \code{\link{noteToSampleRate}}.}

\item{loop}{A positive \code{numeric} indicating the duration of a looped
sample in seconds. A looped sample will be played at least once, even if
the specified duration is less than the sum of \code{\link{loopStart}}
position and the \code{\link{loopLength}}.
See \code{\link{loopStart}} and \code{\link{loopLength}} for details on how
to set (or disable) a loop.}

\item{...}{Further arguments passed on to \code{\link{noteToSampleRate}}.
Can be used to change the video mode, or finetune argument for the call to that method.}
}
\value{
Returns nothing but plays the sample(s) as audio.
}
\description{
Method to play \code{\link{PTSample}}s or all such samples from
\code{\link{PTModule}} objects as audio.
}
\details{
This method plays \code{\link{PTSample}}s and such samples from
\code{\link{PTModule}} objects, using the \code{\link[audio:play]{audio::play}} method
from the audio package. Default \code{\link{fineTune}} and \code{\link{volume}}
as specified for the \code{\link{PTSample}} will be applied when playing
the sample.
}
\examples{
\dontrun{
data("mod.intro")

## play all samples in mod.intro:
playSample(mod.intro, 0.2, loop = 0.5)

## play a chromatic scale using sample number 3:
for (note in c("A-2", "A#2", "B-2", "C-3", "C#3",
               "D-3", "D#3", "E-3", "F-3", "F#3",
               "G-3", "G#3"))
{
  playSample(PTSample(mod.intro, 3), note = note, silence = 0.05, loop = 0.4)
}

## play the sample at a rate based on a specific
## video mode and finetune:
playSample(PTSample(mod.intro, 3), video = "NTSC", finetune = -5)
}

}
\seealso{
Other sample.operations: 
\code{\link{PTSample-class}},
\code{\link{PTSample-method}},
\code{\link{fineTune}()},
\code{\link{loopLength}()},
\code{\link{loopSample}()},
\code{\link{loopStart}()},
\code{\link{loopState}()},
\code{\link{name}},
\code{\link{read.sample}()},
\code{\link{sampleLength}()},
\code{\link{volume}()},
\code{\link{waveform}()},
\code{\link{write.sample}()}

Other sample.rate.operations: 
\code{\link{sampleRate}}

Other play.audio.routines: 
\code{\link{playMod}()},
\code{\link{playWave}()}
}
\author{
Pepijn de Vries
}
\concept{play.audio.routines}
\concept{sample.operations}
\concept{sample.rate.operations}
