% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\name{loopState}
\alias{loopState}
\alias{loopState,PTSample-method}
\title{Get PTSample loop state}
\usage{
\S4method{loopState}{PTSample}(sample)
}
\arguments{
\item{sample}{A \code{\link{PTSample}} object for which the loop state needs
to be determined.}
}
\value{
Returns a \code{logical} value indicating whether a loop is (\code{TRUE})
or isn't (\code{FALSE}) specified for the \code{sample}.
}
\description{
Determines whether a loop is specified for a \code{\link{PTSample}} object.
}
\details{
The loop state is not explicitly stored in a \code{\link{PTSample}} object.
It can be derived from the \code{\link{loopStart}} position and
\code{\link{loopLength}}. This method is provided as a convenient method
to get the state. Use either \code{\link{loopStart}} or \code{\link{loopLength}}
to change the state.
}
\examples{
data("mod.intro")

## Get the loop status of sample number 1
## (it has a loop):
loopState(PTSample(mod.intro, 1))

## Get the loop status of sample number 2
## (it has no loop):
loopState(PTSample(mod.intro, 2))
}
\seealso{
Other loop.methods: 
\code{\link{loopLength}()},
\code{\link{loopSample}()},
\code{\link{loopStart}()}

Other sample.operations: 
\code{\link{PTSample-class}},
\code{\link{PTSample-method}},
\code{\link{fineTune}()},
\code{\link{loopLength}()},
\code{\link{loopSample}()},
\code{\link{loopStart}()},
\code{\link{name}},
\code{\link{playSample}()},
\code{\link{read.sample}()},
\code{\link{sampleLength}()},
\code{\link{volume}()},
\code{\link{waveform}()},
\code{\link{write.sample}()}
}
\author{
Pepijn de Vries
}
\concept{loop.methods}
\concept{sample.operations}
