% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01supporting_functions.r
\name{rawToCharNull}
\alias{rawToCharNull}
\title{Convert raw vectors into a character string}
\usage{
rawToCharNull(raw_dat)
}
\arguments{
\item{raw_dat}{A vector of class \code{raw} to be converted into a \code{character}.}
}
\value{
A \code{character} string based on the \code{raw} data
}
\description{
A function that converts \code{raw} data into a \code{character} string.
}
\details{
The function \code{\link{rawToChar}} will fail on vectors of \code{raw} data
with embedded \code{0x00} data. This function will not fail on embedded \code{0x00} values.
Instead, it will replace embedded \code{0x00} data with white spaces. Note that
leading and trailing \code{0x00} data will be omitted from the result.
}
\examples{
## generate some raw data with an embedded 0x00:
some.raw.data <- as.raw(c(0x68, 0x65, 0x6c, 0x6c, 0x6f, 0x00,
                          0x77, 0x6f, 0x72, 0x6c, 0x64, 0x21))
\dontrun{
## this will fail:
try(rawToChar(some.raw.data))
}

## this will succeed:
rawToCharNull(some.raw.data)

}
\seealso{
Other raw.operations: 
\code{\link{as.raw}()},
\code{\link{nybbleToSignedInt}()},
\code{\link{nybble}()},
\code{\link{rawToPTModule}()},
\code{\link{rawToSignedInt}()},
\code{\link{rawToUnsignedInt}()},
\code{\link{signedIntToNybble}()},
\code{\link{signedIntToRaw}()},
\code{\link{unsignedIntToRaw}()}

Other character.operations: 
\code{\link{as.character}()},
\code{\link{name}},
\code{\link{periodToChar}()},
\code{\link{sampleRate}}
}
\author{
Pepijn de Vries
}
\concept{character.operations}
\concept{raw.operations}
