% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{deletePattern}
\alias{deletePattern}
\alias{deletePattern,PTModule,numeric-method}
\title{Remove a PTPattern table from a PTModule object}
\usage{
\S4method{deletePattern}{PTModule,numeric}(x, index)
}
\arguments{
\item{x}{A \code{\link{PTModule}} from which a
\code{\link{PTPattern}} needs to be removed.}

\item{index}{A \code{numeric} index of the \code{\link{PTPattern}}
table that needs to be removed. The index should be between 1 and
\code{\link{patternLength}}. It's not possible to delete multiple
patterns simultaneously with this method. A \code{\link{PTModule}}
should always hold at least 1 pattern table, therefore, the last
\code{\link{PTPattern}} table cannot be deleted.}
}
\value{
Returns a \code{\link{PTModule}} from which the selected
\code{\link{PTPattern}} is deleted.
}
\description{
This method removes a \code{\link{PTPattern}} from a
\code{\link{PTModule}} object and updates the
\code{\link{patternOrder}} table accordingly.
}
\details{
This method safely removes a \code{\link{PTPattern}} from a
\code{\link{PTModule}} object, guarding the validity of the
\code{\link{PTModule}} object. It therefore also updates
the \code{\link{patternOrder}} table, by renumbering the indices
listed there. The index of the removed object is replaced with a zero
in the \code{\link{patternOrder}} table.
}
\note{
As per ProTracker specification, the pattern indices
stored in the \code{\link{PTModule}} and obtained with
\code{\link{patternOrder}} start at 0. Whereas R starts indexing at 1.
Beware of this discrepancy.
}
\examples{
data("mod.intro")
print(mod.intro)

## delete pattern #2 from mod.intro:

mod.intro <- deletePattern(mod.intro, 2)
print(mod.intro)

}
\seealso{
Other pattern.operations: \code{\link{MODPlugToPTPattern}},
  \code{\link{PTPattern-class}},
  \code{\link{PTPattern-method}},
  \code{\link{PTPatternToMODPlug}},
  \code{\link{appendPattern}}, \code{\link{pasteBlock}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}

Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSamples}},
  \code{\link{clearSong}}, \code{\link{fix.PTModule}},
  \code{\link{modToWave}}, \code{\link{moduleSize}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}},
  \code{\link{patternOrder}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{read.module}},
  \code{\link{trackerFlag}}, \code{\link{write.module}}
}
\author{
Pepijn de Vries
}
