% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{patternOrder}
\alias{patternOrder}
\alias{patternOrder,PTModule-method}
\alias{patternOrder<-}
\alias{patternOrder<-,PTModule,ANY,numeric-method}
\title{Get the pattern order table}
\usage{
\S4method{patternOrder}{PTModule}(x, full = FALSE)

\S4method{patternOrder}{PTModule,ANY,numeric}(x, full = FALSE) <- value
}
\arguments{
\item{x}{A \code{\link{PTModule}} object for which the pattern order table
needs to be returned or modified.}

\item{full}{A \code{logical} value indicating whether the full (\code{TRUE},
default), or only the visible (\code{FALSE}) part of the pattern order table
should be returned. This argument will also affect how new pattern order
tables are assigned (see \code{value}).}

\item{value}{A \code{numeric} \code{vector} (maximum length: 128) holding
\code{\link{PTPattern}} indices minus 1 for the new pattern order table.

When \code{full = TRUE}, the \code{vector} will be padded with zeros to a
length of 128, and the \code{\link{patternOrderLength}} will be set to the
length of \code{value}. When \code{full = FALSE}, \code{value} will only
repplace the part of the order table up to the length of \code{value}. The
remainder of the table is not changed. The \code{\link{patternOrderLength}}
is also not modified in this case.}
}
\value{
For \code{patternOrder}, a \code{vector} of \code{numeric}
\code{\link{PTPattern}} indices is returned.

For \code{patternOrder<-}, an updated version of object \code{x} is returned,
in which the pattern order table is modified based on \code{value}.
}
\description{
The pattern order table is a \code{vector} of \code{numeric} indices of
\code{\link{PTPattern}} tables, which determines in which order the patterns
need to be played. This method returns this \code{vector}.
}
\details{
The actual length of the \code{vector} containing the pattern order is 128
as per ProTracker standards. Only part of this \code{vector} is `visible'
and will be used to determine in which order pattern tables are to be played.
This method can be used to return either the visible or full (all 128) part
of the table. It can also be used to assign a new patter order table.

Note that \code{\link{PTPattern}} indices start at 0, as per ProTracker
standards, whereas R start indices at 1. Hence, add 1 to the indices obtained
with \code{patternOrder}, in order to extract the correct
\code{\link{PTPattern}} from a \code{\link{PTModule}}.

The maximum index plus 1 in the full pattern order table should equal
the number of pattern tables (see \code{\link{patternLength}}) in the
\code{\link{PTModule}}. Is you assign a new pattern order, with a lower
maximum, \code{\link{PTPattern}} objects will get lost (see also examples)!
}
\note{
The maximum number of \code{\link{PTPattern}}s cannot exceed either 64 or
100 (depending on the \code{\link{trackerFlag}}). This means that values in
the order table should also not exceed these values minus 1.
}
\examples{
data("mod.intro")

## get the visible part of the patternOrder table:
patternOrder(mod.intro)

## get the full patternOrder table:
patternOrder(mod.intro, full = TRUE)

## add 1 to get extract the right PTPattern from
## mod.intro:
first.pattern.played <-
  (PTPattern(mod.intro, patternOrder(mod.intro)[1] + 1))

## set a different playing order:
patternOrder(mod.intro) <- c(0:3, 0:3, 0:3)

## The assignment above uses a value that
## longer than the patternOrderLength.
## This means that a part ends up in the
## 'invisible' part of the order table:
patternOrder(mod.intro)
patternOrder(mod.intro, full = TRUE)

## Let's do the same assignment, but update
## the visible part of the table as well:
patternOrder(mod.intro, full = TRUE) <- c(0:3, 0:3, 0:3)

## note that the maximum of the order table plus 1
## equals the patternLength of mod.intro (always the case
## for a valid PTModule object):
max(patternOrder(mod.intro, full = TRUE) + 1) ==
  patternLength(mod.intro)

## Let's do something dangerous. If the replacement
## indices do not hold a maximum value that equals
## the patternLength minus 1, PTPatterns will get lost,
## in order to maintain the validity of mod.intro:
patternOrder(mod.intro) <- rep(0, 12)

}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule-class}},
  \code{\link{appendPattern}}, \code{\link{clearSamples}},
  \code{\link{clearSong}}, \code{\link{deletePattern}},
  \code{\link{modToWave}}, \code{\link{moduleSize}},
  \code{\link{patternLength}},
  \code{\link{patternOrderLength}}, \code{\link{playMod}},
  \code{\link{playingtable}}, \code{\link{read.module}},
  \code{\link{trackerFlag}}, \code{\link{write.module}}

Other pattern.operations: \code{\link{PTPattern-class}},
  \code{\link{PTPattern-method}},
  \code{\link{appendPattern}}, \code{\link{deletePattern}},
  \code{\link{pasteBlock}}, \code{\link{patternLength}},
  \code{\link{patternOrderLength}}
}

