% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/06PTModule.r
\docType{methods}
\name{patternLength}
\alias{patternLength}
\alias{patternLength,PTModule-method}
\title{Get the number of PTPattern tables in a PTModule}
\usage{
\S4method{patternLength}{PTModule}(x)
}
\arguments{
\item{x}{A \code{\link{PTModule}} object for which the number of
\code{\link{PTPattern}} tables need to be returned.}
}
\value{
Returns a \code{numeric} value representing the number of
\code{\link{PTPattern}} tables in object \code{x}.
}
\description{
Get the number of \code{\link{PTPattern}} tables in a \code{\link{PTModule}}
object.
}
\details{
The number of \code{\link{PTPattern}} tables in a \code{\link{PTModule}}
object should range from 1 up to either 64 or 100. The maximum depends on the
\code{\link{trackerFlag}} of the \code{\link{PTModule}} object.
}
\examples{
data("mod.intro")

## Get the number of pattern tables in mod.intro:
patternLength(mod.intro)
}
\author{
Pepijn de Vries
}
\seealso{
Other module.operations: \code{\link{PTModule}},
  \code{\link{PTModule-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{clearSamples}},
  \code{\link{clearSamples,PTModule-method}};
  \code{\link{clearSong}},
  \code{\link{clearSong,PTModule-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{modToWave}},
  \code{\link{modToWave,PTModule-method}};
  \code{\link{moduleSize}},
  \code{\link{moduleSize,PTModule-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}};
  \code{\link{playMod}},
  \code{\link{playMod,PTModule-method}};
  \code{\link{playingtable}},
  \code{\link{playingtable,PTModule-method}};
  \code{\link{read.module}},
  \code{\link{read.module,ANY-method}},
  \code{\link{read.module,character-method}};
  \code{\link{trackerFlag}},
  \code{\link{trackerFlag,PTModule-method}},
  \code{\link{trackerFlag<-}},
  \code{\link{trackerFlag<-,PTModule-method}};
  \code{\link{write.module}},
  \code{\link{write.module,PTModule,ANY-method}},
  \code{\link{write.module,PTModule,character-method}}

Other pattern.operations: \code{\link{PTPattern,PTModule,numeric-method}},
  \code{\link{PTPattern,matrix,missing-method}},
  \code{\link{PTPattern,raw,missing-method}},
  \code{\link{PTPattern-method}},
  \code{\link{PTPattern<-}},
  \code{\link{PTPattern<-,PTModule,numeric,PTPattern-method}};
  \code{\link{PTPattern}}, \code{\link{PTPattern-class}};
  \code{\link{appendPattern}},
  \code{\link{appendPattern,PTModule,PTPattern-method}};
  \code{\link{deletePattern}},
  \code{\link{deletePattern,PTModule,numeric-method}};
  \code{\link{pasteBlock}},
  \code{\link{pasteBlock,PTPattern,matrix,numeric,numeric-method}};
  \code{\link{patternOrderLength}},
  \code{\link{patternOrderLength,PTModule-method}},
  \code{\link{patternOrderLength<-}},
  \code{\link{patternOrderLength<-,PTModule,numeric-method}};
  \code{\link{patternOrder}},
  \code{\link{patternOrder,PTModule-method}},
  \code{\link{patternOrder<-}},
  \code{\link{patternOrder<-,PTModule,ANY,numeric-method}}
}

