% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/topology.R
\name{topology_degree}
\alias{topology_degree}
\title{Degree statistics}
\usage{
topology_degree(graph, power.law = FALSE, fit.line = TRUE)
}
\arguments{
\item{graph}{An igraph object.}

\item{power.law}{Logical value indicating whether the log ratio would be calculated in degree distribution statistics (\code{TRUE}) or not (\code{FALSE}).}

\item{fit.line}{Logical value indicating whether to do line fitting in degree distribution statistics (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A data frame containing the vertex and degree information and plots.
}
\description{
Degree distribution statistics of the network.
}
\examples{
nlocal<-data.frame(c("DVL1","DVL2","DVL3"))
net<-construction(input=nlocal,db="HPRD",species="human",ID.type="Gene symbol",hierarchy=1)
d<-topology_degree(net)
d<-topology_degree(net,power.law=TRUE)
}

