% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/net.comparing.R
\name{net.comparing}
\alias{net.comparing}
\title{Comparing two networks}
\usage{
net.comparing(graph1, graph2, topology.parameters = FALSE, degree = FALSE,
  cc = FALSE, betweenness = FALSE, eccentricity = FALSE,
  ave.path.len = FALSE, figure.type = 1, method = "utest", legendname)
}
\arguments{
\item{graph1}{An igraph object.}

\item{graph2}{An igraph object.}

\item{topology.parameters}{Logical value, indicating whether to do basic compariring (if \code{TRUE}) or not (if \code{FALSE}).}

\item{degree}{Logical value, indicating whether to do degree comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{cc}{Logical value, indicating whether to do clustering coefficient comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{betweenness}{Logical value, indicating whether to do betweenness comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{eccentricity}{Logical value, indicating whether to do eccentricity comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{ave.path.len}{Logical value, indicating whether to do average path comparing (if \code{TRUE}) or not (if \code{FALSE}).}

\item{figure.type}{Type of the plot. See \code{\link{plot}} for more information.}

\item{method}{Test method, only \code{utest} is supported.}

\item{legendname}{Legend name for graph.}
}
\value{
A list of compared results and plot.
}
\description{
Comparing two networks' topological parameters.
}
\examples{
g1<-barabasi.game(100,power=0.8,directed = FALSE)
g2<-erdos.renyi.game(100,p=0.01,directed = FALSE)
res<-net.comparing(g1,g2,degree=TRUE,cc=TRUE,betweenness=FALSE)
}
\references{
Dehmer,M. et al. A large scale analysis of information-theoretic network complexity measures using chemical structures. PLoS ONE, (2009a), 4, e8057.
}
\seealso{
\code{\link{comp.subnet}} and \code{\link{comp.rand.subnet}}.
}

