% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_chain_indices.R
\name{chQMq}
\alias{chQMq}
\title{Calculating the monthly chained quadratic mean of order r quantity index}
\usage{
chQMq(data, start, end, r = 2, interval = FALSE)
}
\arguments{
\item{data}{The user's data frame with information about sold products. It must contain columns: \code{time} (as Date in format: year-month-day,e.g. '2020-12-01'), \code{prices} (as positive numeric), \code{quantities}  (as positive numeric) and \code{prodID} (as numeric, factor or character).}

\item{start}{The base period (as character) limited to the year and month, e.g. "2020-03".}

\item{end}{The research period (as character) limited to the year and month, e.g. "2020-04".}

\item{r}{The real and non-zero parameter.}

\item{interval}{A logical value indicating whether the function is to compare the research period defined by \code{end} to the base period defined by \code{start} (then \code{interval} is set to FALSE) or all fixed base indices are to be calculated. In this latter case, all months from the time interval \code{<start,end>} are considered and \code{start} defines the base period (\code{interval} is set to TRUE).}
}
\value{
The function returns a value (or vector of values) of the monthly chained quadratic mean of order r quantity index - see CPI Manual (2004), Section 17.35, formula 17.30 (page 321).
}
\description{
This function returns a value (or vector of values) of the monthly chained quadratic mean of order r quantity index.
}
\examples{
\donttest{chQMq(sugar, start="2019-01", end="2020-01")}
\donttest{chQMq(sugar, start="2019-01", end="2020-01", r=1.3, interval=TRUE)}
}
\references{
{(2004). \emph{Consumer Price Index Manual. Theory and practice}. ILO/IMF/OECD/UNECE/Eurostat/The World Bank, International Labour Office (ILO), Geneva.}
}
