% Generated by roxygen2 (4.0.2): do not edit by hand
\name{Laplace.sampling}
\alias{Laplace.sampling}
\title{Langevin-Hastings MCMC for conditional simulation}
\usage{
Laplace.sampling(mu, Sigma, y, units.m, control.mcmc, ID.coords = NULL,
  messages = TRUE, plot.correlogram = TRUE)
}
\arguments{
\item{mu}{mean vector of the marginal distribution of the random effect.}

\item{Sigma}{covariance matrix of the marginal distribution of the random effect.}

\item{y}{vector of binomial observations.}

\item{units.m}{vector of binomial denominators.}

\item{control.mcmc}{output from \code{\link{control.mcmc.MCML}}.}

\item{ID.coords}{vector of ID values for the unique set of spatial coordinates obtained from \code{\link{create.ID.coords}}. These must be provided if, for example, spatial random effects are defined at household level but some of the covariates are at individual level. \bold{Warning}: the household coordinates must all be distinct otherwise see \code{\link{jitterDupCoords}}. Default is \code{NULL}.}

\item{messages}{logical; if \code{messages=TRUE} then status messages are printed on the screen (or output device) while the function is running. Default is \code{messages=TRUE}.}

\item{plot.correlogram}{logical; if \code{plot.correlogram=TRUE} the autocorrelation plot of the conditional simulations is displayed.}
}
\value{
A list with the following components

\code{samples}: a matrix, each row of which corresponds to a sample from the predictive distribution.

\code{h}: vector of the values of the tuning constant at each iteration of the Langevin-Hastings MCMC algorithm.
}
\description{
This function simulates from the conditional distribution of a Gaussian random effect, given binomial observations \code{y}.
}
\details{
Conditionally on the random effect \eqn{S}, the data \code{y} follow a binomial distribution with probability \eqn{p} and binomial denominators \code{units.m}. The logistic link function is used for the linear predictor, which assumes the form \deqn{\log(p/(1-p))=S.} The random effect \eqn{S} has a multivariate Gaussian distribution with mean \code{mu} and covariance matrix \code{Sigma}.

\bold{Laplace sampling.} This function generates samples from the distribution of \eqn{S} given the data \code{y}. Specifically a Langevin-Hastings algorithm is used to update \eqn{\tilde{S} = \tilde{\Sigma}^{-1/2}(S-\tilde{s})} where \eqn{\tilde{\Sigma}} and \eqn{\tilde{s}} are the inverse of the negative Hessian and the mode of the distribution of \eqn{S} given \code{y}, respectively. At each iteration a new value \eqn{\tilde{s}_{prop}} for \eqn{\tilde{S}} is proposed from a multivariate Gaussian distribution with mean \deqn{\tilde{s}_{curr}+(h/2)\nabla \log f(\tilde{S} | y),}
where \eqn{\tilde{s}_{curr}} is the current value for \eqn{\tilde{S}}, \eqn{h} is a tuning constant and \eqn{\nabla \log f(\tilde{S} | y)} is the the gradient of the log-density of the distribution of \eqn{\tilde{S}} given \code{y}. The tuning parameter \eqn{h} is updated according to the following adaptive scheme: the value of \eqn{h} at the \eqn{i}-th iteration, say \eqn{h_{i}}, is given by \deqn{h_{i} = h_{i-1}+c_{1}i^{-c_{2}}(\alpha_{i}-0.547),}
where \eqn{c_{1} > 0} and \eqn{0 < c_{2} < 1} are pre-defined constants, and \eqn{\alpha_{i}} is the acceptance rate at the \eqn{i}-th iteration (\eqn{0.547} is the optimal acceptance rate for a multivariate standard Gaussian distribution).
The starting value for \eqn{h}, and the values for \eqn{c_{1}} and \eqn{c_{2}} can be set through the function \code{\link{control.mcmc.MCML}}.

\bold{Random effects at household-level.} When the data consist of two nested levels, such as households and individuals within households, the argument \code{ID.coords} must be used to define the household IDs for each individual. Let \eqn{i} and \eqn{j} denote the \eqn{i}-th household and the \eqn{j}-th person within that household; the logistic link function then assumes the form \deqn{\log(p_{ij}/(1-p_{ij}))=\mu_{ij}+S_{i}} where the random effects \eqn{S_{i}} are now defined at household level and have mean zero.
}
\examples{
set.seed(1234)
data(data_sim)
n.subset <- 50
data_subset <- data_sim[sample(1:nrow(data_sim),n.subset),]
mu <- rep(0,50)
Sigma <- varcov.spatial(coords=data_subset[,c("x1","x2")],
              cov.pars=c(1,0.15),kappa=2)$varcov
control.mcmc <- control.mcmc.MCML(n.sim=1000,burnin=0,thin=1,
                           h=1.65/(n.subset^2/3))
invisible(Laplace.sampling(mu=mu,Sigma=Sigma,
                                       y=data_subset$y,units.m=data_subset$units.m,
                                       control.mcmc=control.mcmc))
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
\seealso{
\code{\link{control.mcmc.MCML}}, \code{\link{create.ID.coords}}.
}

