/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.result.AbstractMethodResult;
import gnu.trove.TLongCollection;
import gnu.trove.list.array.TDoubleArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.util.ArrayList;

public class MetricSynchronizer {
    private ArrayList<AbstractMethodResult> metricList = new ArrayList();
    private boolean isSynchronized = false;
    private TDoubleArrayList[] values;
    private TLongArrayList time;
    private boolean isNaN = true;

    protected void finalize() throws Throwable {
        this.metricList.clear();
        super.finalize();
    }

    public MetricSynchronizer() {
    }

    public MetricSynchronizer(boolean isNaN) {
        this.isNaN = isNaN;
    }

    public void add(AbstractMethodResult metric) {
        this.metricList.add(metric);
        this.isSynchronized = false;
    }

    public int getMetricsNumber() {
        return this.metricList.size();
    }

    public double[] getValue(int i) throws ComputeErrorException {
        return this.getValueList(i).toArray();
    }

    public TDoubleArrayList getValueList(int i) throws ComputeErrorException {
        this.synchronize();
        return this.values[i];
    }

    public long[] getTime() throws ComputeErrorException {
        return this.getTimeList().toArray();
    }

    public TLongArrayList getTimeList() throws ComputeErrorException {
        this.synchronize();
        return this.time;
    }

    private void synchronize() throws ComputeErrorException {
        if (this.isSynchronized) {
            return;
        }
        TLongHashSet set = new TLongHashSet();
        for (AbstractMethodResult e : this.metricList) {
            set.addAll(e.getTime());
        }
        this.time = new TLongArrayList((TLongCollection)set);
        this.time.sort();
        this.values = new TDoubleArrayList[this.metricList.size()];
        int i = 0;
        for (AbstractMethodResult e : this.metricList) {
            this.values[i] = new TDoubleArrayList();
            long[] eTime = e.getTime();
            double[] eValue = e.getValue();
            int k = 0;
            for (int j = 0; j < this.time.size(); ++j) {
                if (k < eTime.length && this.time.getQuick(j) == eTime[k]) {
                    this.values[i].add(eValue[k]);
                    ++k;
                    continue;
                }
                if (this.isNaN) {
                    this.values[i].add(Double.NaN);
                    continue;
                }
                this.values[i].add(0.0);
            }
            ++i;
        }
        this.isSynchronized = true;
    }
}

