/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.util;

import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.api.Metric;
import com.portfolioeffect.quant.client.result.LazyMetric;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.MetricCallable;
import com.portfolioeffect.quant.client.util.ProgressBar;
import com.portfolioeffect.quant.client.util.StopButton;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class MetricExecutor {
    private static final int MAX_THREAD = 100;
    private int activeThreadsNumber = 1;
    private Deque<MetricCallable> list = new ArrayDeque<MetricCallable>();
    private boolean isMultiplexConnection = true;
    private volatile LinkedBlockingDeque<MetricCallable> chanel = new LinkedBlockingDeque();
    private boolean isSingleProgressBar = true;
    private ClientConnection client;

    public MetricExecutor(boolean isSingleProgressBar) {
        this();
        this.isSingleProgressBar = isSingleProgressBar;
    }

    public MetricExecutor() {
    }

    public void add(Metric metric) {
        this.client = metric.getMetric().getPortfolio().getClient();
        if (this.isSingleProgressBar) {
            metric.getMetric().getPortfolio().proggressBarOff();
        }
        this.list.offer(new MetricCallable(metric, this.isMultiplexConnection, this.chanel));
    }

    public void add(Metric metric, Runnable callBack) {
        this.client = metric.getMetric().getPortfolio().getClient();
        if (this.isSingleProgressBar) {
            metric.getMetric().getPortfolio().proggressBarOff();
        }
        this.list.offer(new MetricCallable(metric, callBack, this.isMultiplexConnection, this.chanel));
    }

    public void add(LazyMetric metric) {
        this.client = metric.getPortfolio().getClient();
        if (this.isSingleProgressBar) {
            metric.getPortfolio().proggressBarOff();
        }
        this.list.offer(new MetricCallable(metric, this.isMultiplexConnection, this.chanel));
    }

    public void add(LazyMetric metric, Runnable callBack) {
        this.client = metric.getPortfolio().getClient();
        if (this.isSingleProgressBar) {
            metric.getPortfolio().proggressBarOff();
        }
        this.list.offer(new MetricCallable(metric, callBack, this.isMultiplexConnection, this.chanel));
    }

    public void run() {
        this.run(false);
    }

    public void run(boolean withStopButton) {
        int currentProblemsNumber;
        StopButton stopButton = null;
        AtomicBoolean stopflag = new AtomicBoolean(false);
        if (withStopButton) {
            stopButton = new StopButton(stopflag);
        }
        ExecutorService executorService = Executors.newCachedThreadPool();
        int totalProblemsNumber = currentProblemsNumber = this.list.size();
        ProgressBar progressBar = new ProgressBar();
        this.activeThreadsNumber = Math.min(this.activeThreadsNumber, this.list.size());
        for (int i = 0; i < this.activeThreadsNumber; ++i) {
            executorService.submit(this.list.poll());
        }
        if (this.isSingleProgressBar) {
            progressBar.printCompletionStatus(0, totalProblemsNumber);
        }
        while (!stopflag.get() && currentProblemsNumber > 0) {
            MetricCallable metric = null;
            try {
                metric = this.chanel.poll(200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (metric == null) {
                if (this.list.size() <= 0 || this.activeThreadsNumber >= 100) continue;
                executorService.submit(this.list.poll());
                ++this.activeThreadsNumber;
                continue;
            }
            --this.activeThreadsNumber;
            if (metric.getMetric().isComputed()) {
                --currentProblemsNumber;
                if (this.isSingleProgressBar) {
                    progressBar.printCompletionStatus(totalProblemsNumber - currentProblemsNumber, totalProblemsNumber);
                }
                if (this.list.size() <= 0 || this.activeThreadsNumber >= 100) continue;
                executorService.submit(this.list.poll());
                ++this.activeThreadsNumber;
                continue;
            }
            this.list.offer(metric);
        }
        if (stopButton != null) {
            stopButton.close();
        }
        if (stopflag.get()) {
            executorService.shutdown();
            try {
                executorService.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.list.clear();
            Console.write(" calculation is stopped by user");
        }
        if (this.isSingleProgressBar) {
            progressBar.printCompletionStatus(totalProblemsNumber, totalProblemsNumber);
        }
    }

    public boolean isMultiplexConnection() {
        return this.isMultiplexConnection;
    }

    public void setMultiplexConnection(boolean isMultiplexConnection) {
        this.isMultiplexConnection = isMultiplexConnection;
    }
}

