/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.result;

import com.portfolioeffect.quant.client.model.ComputeErrorException;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.portfolio.Portfolio;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.DateTimeUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMethodResult {
    protected boolean isDebug = false;
    protected boolean hasResult;
    protected boolean hasError;
    protected boolean hasWarning;
    protected String errorMessage;
    protected String warningMessage;
    protected String message;
    protected HashMap<String, String> infoParams = new HashMap();
    protected Map<String, Object> data = new HashMap<String, Object>();
    protected Map<String, String> dataType = new HashMap<String, String>();

    protected abstract void computeMetric() throws ComputeErrorException;

    public abstract void compute();

    public AbstractMethodResult() {
        this.hasError = false;
        this.hasWarning = false;
        this.errorMessage = "";
        this.message = "";
        this.warningMessage = "";
        this.hasResult = false;
    }

    public AbstractMethodResult(String errorMessage) {
        this.hasError = true;
        this.hasWarning = false;
        this.errorMessage = errorMessage;
        this.message = "";
        this.warningMessage = "";
        this.hasResult = false;
    }

    public AbstractMethodResult(String errorMessage, String warnnigMessage) {
        this.hasError = false;
        this.hasWarning = true;
        this.errorMessage = errorMessage;
        this.message = "";
        this.warningMessage = warnnigMessage;
        this.hasResult = false;
    }

    public AbstractMethodResult(boolean hasError, String errorMessage) {
        this.hasError = hasError;
        this.errorMessage = errorMessage;
        this.message = "";
        this.hasWarning = false;
        this.warningMessage = "";
        this.hasResult = false;
    }

    public HashMap<String, String> getInfoParams() {
        return this.infoParams;
    }

    public void setInfoParams(HashMap<String, String> infoParams) {
        this.infoParams = infoParams;
        this.hasResult = true;
    }

    public void setInfo(HashMap<String, String> info) {
        this.infoParams.putAll(info);
        this.hasResult = true;
    }

    public String getDataType(String key) throws ComputeErrorException {
        this.computeMetric();
        return this.dataType.get(key);
    }

    public void setData(String key, ArrayCache value) {
        if (value.isAllNaN()) {
            this.hasError = true;
            this.errorMessage = "Incomplete data for request";
        }
        this.data.put(key, value);
        this.dataType.put(key, value.getType().toString());
        this.hasResult = true;
    }

    public void setData(String key, double[] value) throws IOException {
        ArrayCache arrayValue = new ArrayCache(value);
        if (arrayValue.isAllNaN()) {
            this.hasError = true;
            this.errorMessage = "Incomplete data for request";
        }
        this.data.put(key, arrayValue);
        this.dataType.put(key, arrayValue.getType().toString());
        this.hasResult = true;
    }

    public void setData(String key, long[] value) throws IOException {
        ArrayCache arrayValue = new ArrayCache(value);
        this.data.put(key, arrayValue);
        this.dataType.put(key, arrayValue.getType().toString());
        this.hasResult = true;
    }

    public void setValue(double[] value) throws IOException {
        this.setData("value", value);
    }

    public void setTime(long[] value) throws IOException {
        this.setData("time", value);
    }

    public ArrayCache getDataArrayCache(String key) throws ComputeErrorException {
        this.computeMetric();
        return (ArrayCache)this.data.get(key);
    }

    public void setData(String key, ArrayCache[] value) {
        this.data.put(key, value);
        this.dataType.put(key, value[0].getType().toString());
        this.hasResult = true;
    }

    public ArrayCache[] getDataArrayCacheArray(String key) throws ComputeErrorException {
        this.computeMetric();
        return (ArrayCache[])this.data.get(key);
    }

    public Object getData(String key) throws Exception {
        this.computeMetric();
        return this.data.get(key);
    }

    public String getDataString(String key) throws ComputeErrorException {
        this.computeMetric();
        return (String)this.data.get(key);
    }

    public String[] getDataNames() throws ComputeErrorException {
        this.computeMetric();
        return this.data.keySet().toArray(new String[this.data.keySet().size()]);
    }

    public Portfolio getPortfolio(String key) throws ComputeErrorException {
        this.computeMetric();
        return (Portfolio)this.data.get(key);
    }

    public void setPortfolio(String key, Portfolio portfolio) {
        this.dataType.put(key, "PORTFOLIO");
        this.data.put(key, portfolio);
        this.hasResult = true;
    }

    public long[] getLongArray(String key) throws ComputeErrorException {
        this.computeMetric();
        try {
            if (this.data.containsKey("value")) {
                long[] data = ((ArrayCache)this.data.get(key)).getLongArray(this.getDataArrayCache("value"));
                if (this.isDebug && key.equals("time") && data.length > 0) {
                    Console.writeln("RESULT TIME(" + data.length + "): " + new Timestamp(data[0] + DateTimeUtil.CLIENT_TIME_DELTA) + "\t" + new Timestamp(data[data.length - 1] + DateTimeUtil.CLIENT_TIME_DELTA));
                }
                return data;
            }
            long[] data = ((ArrayCache)this.data.get(key)).getLongArray();
            if (this.isDebug && key.equals("time") && data.length > 0) {
                Console.writeln("RESULT TIME(" + data.length + "): " + new Timestamp(data[0] + DateTimeUtil.CLIENT_TIME_DELTA) + "\t" + new Timestamp(data[data.length - 1] + DateTimeUtil.CLIENT_TIME_DELTA));
            }
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public long[] getTimeWithShift() throws ComputeErrorException {
        long[] dataL = this.getLongArray("time");
        double[] dataD = this.getDoubleArray("value");
        int i = 0;
        while (i < dataL.length) {
            int n = i;
            dataL[n] = dataL[n] + (long)dataD[i] * 1000L;
            ++i;
        }
        return dataL;
    }

    public void addShiftToTime() throws ComputeErrorException, IOException {
        long[] data = this.getTimeWithShift();
        this.setTime(data);
    }

    public void addShiftToTime(AbstractMethodResult result) throws ComputeErrorException, IOException {
        long[] data = result.getTimeWithShift();
        this.setTime(data);
    }

    public void setTime(AbstractMethodResult result) throws ComputeErrorException {
        this.setData("time", result.getDataArrayCache("time"));
    }

    public long[] getTime() throws ComputeErrorException {
        return this.getLongArray("time");
    }

    public long getLastTime() throws ComputeErrorException {
        return this.getLastLong("time");
    }

    public double[] getValue() throws ComputeErrorException {
        return this.getDoubleArray("value");
    }

    public double getLastValue() throws ComputeErrorException {
        return this.getLastDouble("value");
    }

    public long[] getDoubleAsLongArray(String key) throws ComputeErrorException {
        this.computeMetric();
        try {
            long[] data = ((ArrayCache)this.data.get(key)).getDoubleAsLongArray();
            if (this.isDebug && key.equals("time") && data.length > 0) {
                Console.writeln("RESULT TIME(" + data.length + "): " + new Timestamp(data[0] + DateTimeUtil.CLIENT_TIME_DELTA) + "\t" + new Timestamp(data[data.length - 1] + DateTimeUtil.CLIENT_TIME_DELTA));
            }
            return data;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public long getLastLong(String key) throws ComputeErrorException {
        this.computeMetric();
        long[] x = new long[]{};
        try {
            x = ((ArrayCache)this.data.get(key)).getLongArray(this.getDataArrayCache("value"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (x.length == 0) {
            return -1L;
        }
        return x[x.length - 1];
    }

    public double getLastDouble(String key) throws ComputeErrorException {
        this.computeMetric();
        double[] x = new double[]{};
        try {
            ArrayCache d = (ArrayCache)this.data.get(key);
            x = d.getDoubleArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (x.length == 0) {
            return Double.NaN;
        }
        return x[x.length - 1];
    }

    public double[] getLastDoubleArray(String key) throws ComputeErrorException {
        this.computeMetric();
        Object x = new double[][]{new double[0]};
        try {
            x = ((ArrayCache)this.data.get(key)).getDoubleMatrix();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return x[((double[][])x).length - 1];
    }

    public double[] getDoubleArray(String key) throws ComputeErrorException {
        this.computeMetric();
        try {
            double[] data = ((ArrayCache)this.data.get(key)).getDoubleArray();
            if (this.isDebug && data.length > 0) {
                Console.writeln("RESULT DATA(" + data.length + "): " + data[0] + "\t" + data[data.length - 1]);
            }
            return data;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public double[][] getDoubleMatrix(String key) throws ComputeErrorException {
        this.computeMetric();
        try {
            return ((ArrayCache)this.data.get(key)).getDoubleMatrix();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getInfoParam(String key) throws ComputeErrorException {
        this.computeMetric();
        if (!this.infoParams.containsKey(key)) {
            return String.format("No such parameters: %s", key);
        }
        return this.infoParams.get(key);
    }

    public String getParamName() throws ComputeErrorException {
        this.computeMetric();
        String params = "";
        for (String e : this.infoParams.keySet()) {
            params = String.valueOf(params) + " " + e;
        }
        return params;
    }

    public int getValueInt(String key) throws ComputeErrorException {
        this.computeMetric();
        if (!this.infoParams.containsKey(key)) {
            return 0;
        }
        return Integer.parseInt(this.infoParams.get(key));
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean hasError() {
        this.compute();
        return this.hasError;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }

    public void makeLastResultOnlyDouble(String key) throws ComputeErrorException {
        this.computeMetric();
        try {
            ArrayCache newResult = new ArrayCache(ArrayCacheType.NULL);
            double[] resultArray = null;
            try {
                resultArray = this.getDoubleArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (resultArray.length == 0) {
                return;
            }
            newResult = new ArrayCache(new double[]{resultArray[resultArray.length - 1]});
            this.setData(key, newResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyLong(String key) throws ComputeErrorException {
        this.computeMetric();
        try {
            ArrayCache newTime = new ArrayCache(ArrayCacheType.NULL);
            long[] timeArray = null;
            try {
                timeArray = this.getLongArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            newTime = new ArrayCache(new long[]{timeArray[timeArray.length - 1]});
            this.setData(key, newTime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyDouble(String key, int batchSize) throws ComputeErrorException {
        this.computeMetric();
        try {
            ArrayCache newResult = new ArrayCache(ArrayCacheType.NULL);
            double[] resultArray = null;
            try {
                resultArray = this.getDoubleArray(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double[] valuesLast = new double[batchSize];
            if (resultArray.length == 0) {
                return;
            }
            int i = 0;
            while (i < batchSize) {
                valuesLast[i] = resultArray[resultArray.length - batchSize + i];
                ++i;
            }
            newResult = new ArrayCache(valuesLast);
            this.setData(key, newResult);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void makeLastResultOnlyLong(String key, int batchSize) throws ComputeErrorException {
        this.computeMetric();
        try {
            ArrayCache newTime = new ArrayCache(ArrayCacheType.NULL);
            long[] timeArray = null;
            timeArray = this.getLongArray(key);
            newTime = new ArrayCache(new long[]{timeArray[timeArray.length - 1]});
            this.setData(key, newTime);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String[] getStringArray(String key) throws ComputeErrorException {
        this.computeMetric();
        try {
            return ((ArrayCache)this.data.get(key)).getStringArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isHasResult() {
        return this.hasResult;
    }

    public boolean isNaNFiltered() throws ComputeErrorException {
        if (this.data.containsKey("value")) {
            return this.getDataArrayCache("value").isNaNFiltered();
        }
        return true;
    }

    public void setNaNFiltered(boolean isNaNFiltered) throws Exception {
        if (!this.data.containsKey("value")) {
            throw new Exception("Error in MethodResult -1");
        }
        this.getDataArrayCache("value").setNaNFiltered(isNaNFiltered);
    }

    public boolean isNaN2Zero() throws ComputeErrorException {
        if (this.data.containsKey("value")) {
            return this.getDataArrayCache("value").isNaN2Zero();
        }
        return true;
    }

    public void setNaN2Zero(boolean isNaN2Zero) throws Exception {
        if (!this.data.containsKey("value")) {
            throw new Exception("Error in MethodResult -1");
        }
        this.getDataArrayCache("value").setNaN2Zero(isNaN2Zero);
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
    }

    protected void finalize() throws Throwable {
        this.data.clear();
        super.finalize();
    }
}

