/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.template.operator;

import org.openfast.NumericValue;
import org.openfast.ScalarValue;
import org.openfast.template.Scalar;
import org.openfast.template.operator.Operator;
import org.openfast.template.operator.OperatorCodec;
import org.openfast.template.type.Type;

final class IncrementIntegerOperatorCodec
extends OperatorCodec {
    private static final long serialVersionUID = 1L;

    IncrementIntegerOperatorCodec(Operator operator, Type[] types) {
        super(operator, types);
    }

    public ScalarValue getValueToEncode(ScalarValue value, ScalarValue priorValue, Scalar field) {
        if (priorValue == null) {
            return value;
        }
        if (value == null) {
            if (field.isOptional()) {
                if (priorValue == ScalarValue.UNDEFINED && field.getDefaultValue().isUndefined()) {
                    return null;
                }
                return ScalarValue.NULL;
            }
            throw new IllegalArgumentException();
        }
        if (priorValue.isUndefined()) {
            if (value.equals(field.getDefaultValue())) {
                return null;
            }
            return value;
        }
        if (!value.equals(((NumericValue)priorValue).increment())) {
            return value;
        }
        return null;
    }

    public ScalarValue decodeValue(ScalarValue newValue, ScalarValue previousValue, Scalar field) {
        return newValue;
    }

    public ScalarValue decodeEmptyValue(ScalarValue previousValue, Scalar field) {
        if (previousValue == null) {
            return null;
        }
        if (previousValue.isUndefined()) {
            if (field.getDefaultValue().isUndefined()) {
                if (field.isOptional()) {
                    return null;
                }
                throw new IllegalStateException("Field with operator increment must send a value if no previous value existed.");
            }
            return field.getDefaultValue();
        }
        return ((NumericValue)previousValue).increment();
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }
}

