% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolynomF.R
\name{polynom}
\alias{polynom}
\alias{polynomial}
\alias{as_polynom}
\alias{as.polynom}
\alias{is_polynom}
\alias{is.polynom}
\alias{polylist}
\alias{is_polylist}
\alias{is.polylist}
\alias{as_polylist}
\alias{as.polylist}
\title{Polynomial construction}
\usage{
polynom(a = c(0, 1), ..., eps = 0)

polynomial(a = c(0, 1), ..., eps = 0)

as_polynom(a)

as.polynom(a)

is_polynom(a)

is.polynom(a)

polylist(...)

is_polylist(x)

is.polylist(x)

as_polylist(x)

as.polylist(x)
}
\arguments{
\item{a}{A \code{polynom} object, or a numeric vector of coefficients
(in "power series" order) or a vector object which can be
coerced to one.}

\item{...}{Additional arguments, currently ignored.}

\item{eps}{A small non-negative tolerance to check for zero components.}

\item{x}{An object of class \code{"polylist"}, at least potentially.}
}
\value{
A polynomial object.
}
\description{
Functions to construct polynomial objects and check class membership
}
\examples{
(x <- polynomial())
(p <- polynomial(c(1, 5, 2, 2)/10))
plot(p, xlim = 0:1, ylim = 0:1)
P <- p
for(j in 1:7) {
  lines(P, col = j)
  P <- p(P)
}
(r <- solve(p-x))
segments(r, 0, r, p(r), lty = "dashed")
}
