% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_ftir_directory}
\alias{read_ftir_directory}
\title{Read FTIR file}
\usage{
read_ftir_directory(path, files, sample_names = NA, ...)
}
\arguments{
\item{path}{Path to the file. Default is the current working directory, as \code{"."}.

Chemin d'accès au fichier. Par défaut, il s'agit du répertoire de travail actuel, sous la forme \code{"."}.}

\item{files}{File names, required.

Noms de fichiers, obligatoires.}

\item{sample_names}{Name for sample_id column in the returned data.frame. If not provided, the file names are used without the extension.

Nom de la colonne sample_id dans le data.frame renvoyé. S'il n'est pas fourni, les noms de fichiers sont utilisés sans l'extension.}

\item{...}{Additional parameters to pass to the file reading function. For CSV files, see \code{\link[utils:read.table]{utils::read.csv()}}, it may be wise to pass \code{col.names} to disambiguate the input data.

Paramètres supplémentaires à transmettre à la fonction de lecture de fichier. Pour les fichiers CSV, voir \code{\link[utils:read.table]{utils::read.csv()}}, il peut être judicieux de passer \code{col.names} pour désambiguïser les données d'entrée.}
}
\value{
a data.frame containing the spectral data from the files.

un data.frame contenant les données spectrales des fichiers.
}
\description{
Reads provided files and returns a data.frame in the proper format for PlotFTIR functions.

Lit les fichiers fournis et renvoie un data.frame au format approprié pour les fonctions PlotFTIR.
}
\examples{
# Putting some files in a temp dir to read back into PlotFTIR:
td <- tempdir()
write.csv(sample_spectra[sample_spectra$sample_id == "paper", c("wavenumber", "absorbance")],
  file = file.path(td, "ftir_sample_1.csv"), row.names = FALSE
)
write.csv(sample_spectra[sample_spectra$sample_id == "toluene", c("wavenumber", "absorbance")],
  file = file.path(td, "ftir_sample_2.csv"), row.names = FALSE
)

# Read .csv files from the temp directory and call them `sample-1` and `sample-2`
read_ftir_directory(td, c("ftir_sample_1.csv", "ftir_sample_2.csv"), c("sample-1", "sample-2"))

}
\seealso{
\code{\link[=read_ftir]{read_ftir()}}
}
