% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VGM_integrate.R
\name{VGM_integrate}
\alias{VGM_integrate}
\title{Utility for VDJ GEX matrix to integrated VDJ and GEX objects after addition of data to either}
\usage{
VGM_integrate(VGM, columns.to.transfer, genes.to.VDJ, seurat.slot)
}
\arguments{
\item{VGM}{Output object from the VDJ_GEX_matrix function (VDJ_GEX_matrix.output)}

\item{columns.to.transfer}{Optional. Character Vector. Column names of either the VDJ matrix or GEX meta.data that should be transferred to the corresponding other matrix. if not provided all columns missing from one will be integrated into the other matrix}

\item{genes.to.VDJ}{Character vector of gene names in GEX. In many cases it is useful to extract expression values for a gene to metadata. This is done via SeuratObject::FetchData(vars  = genes,slot = seurat.slot) function. The VGM integrate takes gene ids, extracts these and adds them to the VDJ dataframe. If provided, no other columns are integrated between VDJ and GEX and columns.to.transfer is ignored.}

\item{seurat.slot}{GEX object data slot to pull from. Can be 'counts', 'data', or 'scale.data'}
}
\value{
An output object from the VDJ_GEX_matrix function with added columns in VDJ or GEX
}
\description{
(Re)-intergrated VDJ and GEX of one or two separate VGM objects. This can be used as a simple "updating" utility function, if metadata has been added to the VDJ dataframe and is also needed in the GEX matrix or the reverse. Entries are integrated by barcode. If barcodes have been altered (barcode column in VDJ and cell names in GEX), the function will not yield results
}
\examples{

small_vgm[[1]] <- VDJ_clonotype(VDJ=Platypus::small_vgm[[1]],
clone.strategy="cdr3.nt",
hierarchical = "single.chains", global.clonotype = TRUE)

small_vgm <- VGM_integrate(
VGM = small_vgm,
columns.to.transfer = NULL) #transfer all new columns

small_vgm <- VGM_integrate(
VGM = small_vgm,
columns.to.transfer = c("global_clonotype_id_cdr3.nt"))

small_vgm <- VGM_integrate(
small_vgm, genes.to.VDJ = c("CD19","CD24A"),seurat.slot = "counts")
}
