% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GEX_scatter_coexpression.R
\name{GEX_scatter_coexpression}
\alias{GEX_scatter_coexpression}
\title{Scatter plot for coexpression of two selected genes}
\usage{
GEX_scatter_coexpression(GEX, gene.1, gene.2, color.theme)
}
\arguments{
\item{GEX}{GEX seurat object generated with VDJ_GEX_matrix}

\item{gene.1}{Character. Name of a gene in rownames(VDJ.matrix)}

\item{gene.2}{Character. Name of a gene in rownames(VDJ.matrix)}

\item{color.theme}{Character. A color to use for the composite plot}
}
\value{
Returns a gridplot showing coexpression scatterplot as well as histograms of gene.1 and gene.2
}
\description{
Plots a composite figure showing single marker expression as histograms and coexpression as a scatterplot.
}
\examples{
gene1 <- "CD24A"
gene2 <- "CD83"
GEX_scatter_coexpression(GEX = Platypus::small_vgm[[2]], gene1,gene2)

}
