% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Echidna_vae_generate.R
\name{Echidna_vae_generate}
\alias{Echidna_vae_generate}
\title{Simulate B or T cell receptor sequences by variational autoencodes(VAEs) trained with experimental data.}
\usage{
Echidna_vae_generate(
  sequence,
  n.train,
  n.sample,
  batch.size,
  latent.dim,
  intermediate.dim,
  epochs,
  epsilon.std,
  null.threshold
)
}
\arguments{
\item{sequence}{a vector of seuqnece the model to be trained on}

\item{n.train}{number of sequence to be used in training set, the rest will be in testing set}

\item{n.sample}{number of new sequence to generate from VAE model}

\item{batch.size}{set to larger to save time, set to smaller to same computing power}

\item{latent.dim}{parameter used in VAE model}

\item{intermediate.dim}{parameter used in VAE model}

\item{epochs}{parameter used in VAE model}

\item{epsilon.std}{parameter used in VAE model}

\item{null.threshold}{threshold of predicted value to be considered as an existing base, default is 0.05. When generated sequence is too short, lower this threshold.}
}
\value{
A simulated VDJ repertoire on the basis of the input experimental repertoire
}
\description{
Simulate B or T cell receptor sequences by variational autoencodes(VAEs) trained with experimental data.
}
