% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ellipse.R
\name{Ellipse}
\alias{Ellipse}
\title{R6 class representing an ellipse}
\description{
An ellipse is given by a center, two radii (\code{rmajor}
and \code{rminor}), and the angle (\code{alpha}) between the major axis and
the horizontal direction.
}
\examples{

## ------------------------------------------------
## Method `Ellipse$new`
## ------------------------------------------------

Ellipse$new(c(1,1), 3, 2, 30)

## ------------------------------------------------
## Method `Ellipse$matrix`
## ------------------------------------------------

ell <- Ellipse$new(c(1,1), 5, 1, 30)
S <- ell$matrix()
O <- ell$center
pts <- ell$path(4L) # four points on the ellipse
apply(pts, 1L, function(M) t(M-O) \%*\% S \%*\% (M-O))

## ------------------------------------------------
## Method `Ellipse$diameter`
## ------------------------------------------------

ell <- Ellipse$new(c(1,1), 5, 2, 30)
diameters <- lapply(c(0, pi/3, 2*pi/3), ell$diameter)
plot(NULL, asp = 1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell)
invisible(lapply(diameters, draw))

## ------------------------------------------------
## Method `Ellipse$tangent`
## ------------------------------------------------

ell <- Ellipse$new(c(1,1), 5, 2, 30)
tangents <- lapply(c(0, pi/3, 2*pi/3, pi, 4*pi/3, 5*pi/3), ell$tangent)
plot(NULL, asp = 1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell, col = "yellow")
invisible(lapply(tangents, draw, col = "blue"))

## ------------------------------------------------
## Method `Ellipse$regressionLines`
## ------------------------------------------------

ell <- Ellipse$new(c(1,1), 5, 2, 30)
reglines <- ell$regressionLines()
plot(NULL, asp = 1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell, lwd = 2)
draw(reglines$YonX, lwd = 2, col = "blue")
draw(reglines$XonY, lwd = 2, col = "green")

## ------------------------------------------------
## Method `Ellipse$boundingbox`
## ------------------------------------------------

ell <- Ellipse$new(c(2,2), 5, 3, 40)
box <- ell$boundingbox()
plot(NULL, asp = 1, xlim = box$x, ylim = box$y, xlab = NA, ylab = NA)
draw(ell, col = "seaShell", border = "blue")
abline(v = box$x, lty = 2); abline(h = box$y, lty = 2)

## ------------------------------------------------
## Method `Ellipse$randomPoints`
## ------------------------------------------------

ell <- Ellipse$new(c(1,1), 5, 2, 30)
pts <- ell$randomPoints(100)
plot(NULL, type="n", asp=1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell, lwd = 2)
points(pts, pch = 19, col = "blue")
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{center}}{get or set the center}

\item{\code{rmajor}}{get or set the major radius of the ellipse}

\item{\code{rminor}}{get or set the minor radius of the ellipse}

\item{\code{alpha}}{get or set the angle of the ellipse}

\item{\code{degrees}}{get or set the \code{degrees} field}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Ellipse$new()}}
\item \href{#method-print}{\code{Ellipse$print()}}
\item \href{#method-isEqual}{\code{Ellipse$isEqual()}}
\item \href{#method-equation}{\code{Ellipse$equation()}}
\item \href{#method-includes}{\code{Ellipse$includes()}}
\item \href{#method-contains}{\code{Ellipse$contains()}}
\item \href{#method-matrix}{\code{Ellipse$matrix()}}
\item \href{#method-path}{\code{Ellipse$path()}}
\item \href{#method-diameter}{\code{Ellipse$diameter()}}
\item \href{#method-pointFromAngle}{\code{Ellipse$pointFromAngle()}}
\item \href{#method-semiMajorAxis}{\code{Ellipse$semiMajorAxis()}}
\item \href{#method-semiMinorAxis}{\code{Ellipse$semiMinorAxis()}}
\item \href{#method-foci}{\code{Ellipse$foci()}}
\item \href{#method-tangent}{\code{Ellipse$tangent()}}
\item \href{#method-regressionLines}{\code{Ellipse$regressionLines()}}
\item \href{#method-boundingbox}{\code{Ellipse$boundingbox()}}
\item \href{#method-randomPoints}{\code{Ellipse$randomPoints()}}
\item \href{#method-clone}{\code{Ellipse$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
Create a new \code{Ellipse} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$new(center, rmajor, rminor, alpha, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{center}}{a point, the center of the rotation}

\item{\code{rmajor}}{positive number, the major radius}

\item{\code{rminor}}{positive number, the minor radius}

\item{\code{alpha}}{a number, the angle between the major axis and the
horizontal direction}

\item{\code{degrees}}{logical, whether \code{alpha} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Ellipse} object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{Ellipse$new(c(1,1), 3, 2, 30)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\subsection{Method \code{print()}}{
Show instance of an \code{Ellipse} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-isEqual"></a>}}
\subsection{Method \code{isEqual()}}{
Check whether the reference ellipse equals an ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$isEqual(ell)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ell}}{An \code{Ellipse} object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-equation"></a>}}
\subsection{Method \code{equation()}}{
The coefficients of the implicit equation of the ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$equation()}\if{html}{\out{</div>}}
}

\subsection{Details}{
The implicit equation of the ellipse is
\code{Ax² + Bxy + Cy² + Dx + Ey + F = 0}. This method returns
A, B, C, D, E and F.
}

\subsection{Returns}{
A named numeric vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-includes"></a>}}
\subsection{Method \code{includes()}}{
Check whether a point lies on the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$includes(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-contains"></a>}}
\subsection{Method \code{contains()}}{
Check whether a point is contained in the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$contains(M)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{M}}{a point}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-matrix"></a>}}
\subsection{Method \code{matrix()}}{
Returns the 2x2 matrix \code{S} associated to the reference
ellipse. The equation of the ellipse is \code{t(M-O) \%*\% S \%*\% (M-O) = 1}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$matrix()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(1,1), 5, 1, 30)
S <- ell$matrix()
O <- ell$center
pts <- ell$path(4L) # four points on the ellipse
apply(pts, 1L, function(M) t(M-O) \%*\% S \%*\% (M-O))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-path"></a>}}
\subsection{Method \code{path()}}{
Path that forms the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$path(npoints = 100L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{npoints}}{number of points of the path}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A matrix with two columns \code{x} and \code{y} of
length \code{npoints}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-diameter"></a>}}
\subsection{Method \code{diameter()}}{
Diameter and conjugate diameter of the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$diameter(t, conjugate = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{a number, the diameter only depends on \code{t} modulo
\code{pi}; the axes correspond to \code{t=0} and \code{t=pi/2}}

\item{\code{conjugate}}{logical, whether to return the conjugate diameter as well}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{Line} object or a list of two \code{Line} objects if
\code{conjugate = TRUE}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(1,1), 5, 2, 30)
diameters <- lapply(c(0, pi/3, 2*pi/3), ell$diameter)
plot(NULL, asp = 1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell)
invisible(lapply(diameters, draw))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-pointFromAngle"></a>}}
\subsection{Method \code{pointFromAngle()}}{
Intersection point of the ellipse with the half-line
starting at the ellipse center and with director angle \code{theta}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$pointFromAngle(theta, degrees = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{theta}}{a number, the angle, or a numeric vector}

\item{\code{degrees}}{logical, whether \code{theta} is given in degrees}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A point of the ellipse if \code{length(theta)==1} or a
two-column matrix of points of the ellipse if
\code{length(theta) > 1} (one point per row).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-semiMajorAxis"></a>}}
\subsection{Method \code{semiMajorAxis()}}{
Semi-major axis of the ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$semiMajorAxis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A segment (\code{Line} object).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-semiMinorAxis"></a>}}
\subsection{Method \code{semiMinorAxis()}}{
Semi-minor axis of the ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$semiMinorAxis()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A segment (\code{Line} object).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-foci"></a>}}
\subsection{Method \code{foci()}}{
Foci of the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$foci()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with the two foci.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-tangent"></a>}}
\subsection{Method \code{tangent()}}{
Tangents of the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$tangent(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{an angle, there is one tangent for each value of \code{t}
modulo \code{2*pi}; for \code{t = 0, pi/2, pi, -pi/2}, these are the
tangents at the vertices of the ellipse}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(1,1), 5, 2, 30)
tangents <- lapply(c(0, pi/3, 2*pi/3, pi, 4*pi/3, 5*pi/3), ell$tangent)
plot(NULL, asp = 1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell, col = "yellow")
invisible(lapply(tangents, draw, col = "blue"))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-regressionLines"></a>}}
\subsection{Method \code{regressionLines()}}{
Regression lines. The regression line of y on x intersects
the ellipse at its rightmost point and its leftmost point.
The tangents at these points are vertical.
The regression line of x on y intersects the ellipse at its
topmost point and its bottommost point.
The tangents at these points are horizontal.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$regressionLines()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with two \code{Line} objects:
the regression line of y on x and the regression line of x on y.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(1,1), 5, 2, 30)
reglines <- ell$regressionLines()
plot(NULL, asp = 1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell, lwd = 2)
draw(reglines$YonX, lwd = 2, col = "blue")
draw(reglines$XonY, lwd = 2, col = "green")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-boundingbox"></a>}}
\subsection{Method \code{boundingbox()}}{
Return the smallest rectangle parallel to the axes
which contains the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$boundingbox()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list with two components: the x-limits in \code{x} and the
y-limits in \code{y}.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(2,2), 5, 3, 40)
box <- ell$boundingbox()
plot(NULL, asp = 1, xlim = box$x, ylim = box$y, xlab = NA, ylab = NA)
draw(ell, col = "seaShell", border = "blue")
abline(v = box$x, lty = 2); abline(h = box$y, lty = 2)
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-randomPoints"></a>}}
\subsection{Method \code{randomPoints()}}{
Random points on or in the reference ellipse.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$randomPoints(n, where = "in")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{an integer, the desired number of points}

\item{\code{where}}{\code{"in"} to generate inside the ellipse,
\code{"on"} to generate on the ellipse}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The generated points in a two columns matrix with \code{n} rows.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{ell <- Ellipse$new(c(1,1), 5, 2, 30)
pts <- ell$randomPoints(100)
plot(NULL, type="n", asp=1, xlim = c(-4,6), ylim = c(-2,4),
     xlab = NA, ylab = NA)
draw(ell, lwd = 2)
points(pts, pch = 19, col = "blue")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Ellipse$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
