% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genPhytree.R
\name{genPhytree}
\alias{genPhytree}
\title{Create a Phylogenetic Tree Object}
\usage{
genPhytree(manipulated_stringset, incompleteDist = TRUE)
}
\arguments{
\item{manipulated_stringset}{A manipulated string set object.}

\item{incompleteDist}{A logical value to state whether to create a tree from incomplete distances.}
}
\value{
A phylogenetic tree object
}
\description{
Create a phylo tree object using a manipulated DNA string set object.
}
\examples{
# create and plot a phylo tree
specdf_Anth <- querySpecData("Antheraea polyphemus")[1:10,]

DNABin_Anth <- genDNABin(specdf_Anth)

DNAStringset_Anth <- genDNAStringSet(DNABin_Anth)

DNAStringSet_Anth_manipulated <- ManipStringSet(DNAStringset_Anth)

Phytree_Anth <- genPhytree(DNAStringSet_Anth_manipulated)

Phytree_Anth$edge.length <- Phytree_Anth$edge.length + (mean(Phytree_Anth$edge.length) * 0.1)

plot(Phytree_Anth)
}
