% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matchedDiagnostics.R
\name{matchedDiagnostics}
\alias{matchedDiagnostics}
\title{Compare characteristics of cohort matched to database population}
\usage{
matchedDiagnostics(cohort, matchedSample = 1000)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}

\item{matchedSample}{The number of people to take a random sample for
matching. If NULL, no sampling will be performed.}
}
\value{
A summarised result
}
\description{
A summary of the cohort that is matched to the original cohort that has been
given by the user. Such summary contains basic cohort summary including
number of visits within one year prior of the cohort_start_date, as well as
a large scale charactersitics using the following domians of OMOP CDM:

* condition_occurrence
* visit_occurrence
* measurement
* procedure_occurrence
* observation
* drug_exposure
}
\examples{
\donttest{
library(PhenotypeR)

cdm <- mockPhenotypeR()

result <- matchedDiagnostics(cdm$my_cohort)

CDMConnector::cdmDisconnect(cdm = cdm)
}
}
