\name{NetSelectivity}
\alias{NetSelectivity}
\title{Net selectivity of the return distribution}
\usage{
  NetSelectivity(Ra, Rb, Rf = 0, ...)
}
\arguments{
  \item{Ra}{an xts, vector, matrix, data frame, timeSeries
  or zoo object of asset returns}

  \item{Rb}{return vector of the benchmark asset}

  \item{Rf}{risk free rate, in same period as your returns}

  \item{\dots}{any other passthru parameters}
}
\description{
  Net selectivity is the remaining selectivity after
  deducting the amount of return require to justify not
  being fully diversified
}
\details{
  If net selectivity is negative the portfolio manager has
  not justified the loss of diversification

  \deqn{Net selectivity = \alpha - d}{Net selectivity =
  Selectity - diversification}

  where \eqn{\alpha} is the selectivity and \eqn{d} is the
  diversification
}
\examples{
data(portfolio_bacon)
print(NetSelectivity(portfolio_bacon[,1], portfolio_bacon[,2])) #expected -0.017

data(managers)
print(NetSelectivity(managers['1996',1], managers['1996',8]))
print(NetSelectivity(managers['1996',1:5], managers['1996',8]))
}
\author{
  Matthieu Lestel
}
\references{
  Carl Bacon, \emph{Practical portfolio performance
  measurement and attribution}, second edition 2008 p.78
}
\keyword{distribution}
\keyword{models}
\keyword{multivariate}
\keyword{ts}

