% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bt.test.R
\name{bt.test}
\alias{bt.test}
\title{Systemic test for the assumptions of the Bradley-Terry model}
\usage{
bt.test(conf.mat, baseline = 1, maxLength = 2, reps = 1000)
}
\arguments{
\item{conf.mat}{an N-by-N matrix. The matrix should be a conflict matrix with element i,j
representing the number of times i has beaten j.}

\item{baseline}{an integer between 1 and N inclusive identifying
the agent with dominance index equal to zero.}

\item{maxLength}{an integer indicating maximum path length used
in \code{conductance}}

\item{reps}{an integer indicating number of conflict matrices
simulated to estimate the sampling distribution under the BT model.}
}
\value{
A list of 3 elements.
 \item{stat}{value of the test statistic}
 \item{dist}{estimated sampling distribution of the test statistics under the BT model.}
 \item{p.val}{p-value of the test}
}
\description{
\code{bt.test} Systemic test for the assumptions of the Bradley-Terry model,
 transitivity and monotonic win-loss relationship.
 That is, if \eqn{A > B} and \eqn{B > C} then \eqn{A > C} and
 \eqn{Pr(A beats C)} > \eqn{Pr(B beats C)}.
}
\details{
The value of the test statistic should be within the estimated
sampling distribution of the test statistics under the BT model.
The p-value of the test indicates the probability of statistics in the estimated sampling distribution
is larger than the test statistic.
It is not appropriate to use Bradley-Terry model if value of the test statistic is higher than
the estimated sampling distribution of the test statistics.
}
\examples{
# create an edgelist
edgelist1 <- data.frame(col1 = sample(letters[1:15], 200, replace = TRUE),
                        col2 = sample(letters[1:15], 200, replace = TRUE),
                       stringsAsFactors = FALSE)
edgelist1 <- edgelist1[-which(edgelist1$col1 == edgelist1$col2), ]
# convert an edgelist to conflict matrix
confmatrix_bt <- as.conflictmat(edgelist1)
# test the assumptions of the Bradley-Terry model
# not run:
# condTestoutput <- bt.test(confmatrix_bt)
}
\references{
Shev, A., Fujii, K., Hsieh, F., & McCowan, B. (2014). Systemic Testing on Bradley-Terry Model against Nonlinear Ranking Hierarchy. PloS one, 9(12), e115367.
}

