% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{lgmm}
\alias{lgmm}
\title{Learn a Generalized Mallows Model}
\usage{
lgmm(
  data,
  sigma_0_ini = identity.permutation(dim(data)[2]),
  dist.name = "kendall",
  estimation = "approx"
)
}
\arguments{
\item{data}{the matrix with the permutations to estimate}

\item{sigma_0_ini}{optional the initial guess for the consensus permutation}

\item{dist.name}{optional name of the distance used by the GMM. One of: kendall (default), cayley, hamming}

\item{estimation}{optional select the approximated or the exact. One of: approx, exact}
}
\value{
A list with the parameters of the estimated distribution: the
mode and the dispersion parameter vector
}
\description{
Learn the parameter of the distribution of a sample of n permutations 
comming from a Generalized Mallows Model (GMM).
}
\examples{
data <- matrix(c(1,2,3,4, 1,4,3,2, 1,2,4,3), nrow = 3, ncol = 4, byrow = TRUE)
lgmm(data, dist.name="kendall", estimation="approx")
lgmm(data, dist.name="cayley", estimation="approx")
lgmm(data, dist.name="cayley", estimation="exact")
lgmm(data, dist.name="hamming", estimation="approx")
}
\references{
"Ekhine Irurozki, Borja Calvo, Jose A. Lozano (2016). PerMallows: An R Package for Mallows and Generalized Mallows Models. Journal of Statistical Software, 71(12), 1-30. doi:10.18637/jss.v071.i12"
}
