% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alphaScreening.R
\name{alphaScreening}
\alias{alphaScreening}
\title{Screening using the alpha outperformance ratio}
\usage{
alphaScreening(X, factors = NULL, control = list())
}
\arguments{
\item{X}{Matrix \eqn{(T \times N)}{(TxN)} of \eqn{T} returns for the \eqn{N}
funds. \code{NA} values are allowed.}

\item{factors}{Matrix \eqn{(T \times K)}{(TxK)} of \eqn{T} returns for the
\eqn{K} factors. \code{NA} values are allowed.}

\item{control}{Control parameters (see *Details*).}
}
\value{
A list with the following components:\cr

\code{n}: Vector (of length \eqn{N}) of number of non-\code{NA}
observations.\cr

\code{npeer}: Vector (of length \eqn{N}) of number of available peers.\cr

\code{alpha}: Vector (of length \eqn{N}) of unconditional alpha.\cr

\code{dalpha}: Matrix (of size \eqn{N \times N}{NxN}) of alpha
differences.\cr

\code{tstat}: Matrix (of size \eqn{N \times N}{NxN}) of t-statistics.\cr

\code{pval}: Matrix (of size \eqn{N \times N}) of p-values of test for alpha
differences.\cr

\code{lambda}: Vector (of length \eqn{N}) of lambda values.\cr

\code{pizero}: Vector (of length \eqn{N}) of probability of equal
performance.\cr

\code{pipos}: Vector (of length \eqn{N}) of probability of outperformance
performance.\cr

\code{pineg}: Vector (of length \eqn{N}) of probability of underperformance
performance.
}
\description{
Function which performs the screening of a universe of returns, and
computes the alpha outperformance ratio.
}
\details{
The alpha measure (Treynor and Black 1973, Carhart 1997, Fung and Hsieh
2004) is one industry standard for measuring the absolute risk adjusted
performance of hedge funds. We propose to complement the alpha measure with
the fund's alpha outperformance ratio, defined as the percentage number of
funds that have a significantly lower alpha. In a pairwise testing
framework, a fund can have a significantly higher alpha because of luck. We
correct for this by applying the false discovery rate approach by Storey (2002).

The methodology proceeds as follows: 
\itemize{
\item (1) compute all pairwise tests of alpha differences. This means that for a universe of
\eqn{N} funds, we perform \eqn{N(N-1)/2}{N*(N-1)/2} tests. The algorithm has
been parallelized and the computational burden can be splitted across several
cores. The number of cores can be defined in \code{control}, see below.

\item (2) for each fund, the false discovery rate approach by Storey (2002)
is used to determine the proportions of over, equal, and underperfoming
funds, in terms of alpha, in the database.}

The argument \code{control} is a list that can supply any of the following
components:
\itemize{
\item \code{'hac'} Heteroscedastic-autocorrelation consistent
standard errors. Default: \code{hac = FALSE}.
\item \code{'minObs'} Minimum number of concordant observations to compute the ratios. Default:
\code{minObs = 10}.
\item \code{'minObsPi'} Minimum number of observations
for computing the p-values). Default: \code{minObsPi = 1}.
\item \code{'nCore'} Number of cores used to perform the screeing. Default:
\code{nCore = 1}.
\item \code{'lambda'} Threshold value to compute pi0.
Default: \code{lambda = NULL}, i.e. data driven choice.
}
}
\note{
Further details on the methdology with an application to the hedge
fund industry is given in Ardia and Boudt (2016). 

Application of the false discovery rate approach applied to the mutual fund
industry has been presented in Barras, Scaillet and Wermers (2010).

Currently, the HAC asymptotic and studentized circular block bootstrap
presented in Ledoit and Wolf (2008) are not supported by the
\code{alphaScreening} function.
}
\examples{
## Load the data (randomized data of monthly hedge fund returns)
data("hfdata")
rets = hfdata[,1:10]

## Run alpha screening 
ctr = list(nCore = 1)
alphaScreening(rets, control = ctr)

## Run alpha screening with HAC standard deviation
ctr = list(nCore = 1, hac = TRUE)
alphaScreening(rets, control = ctr)
}
\author{
David Ardia and Kris Boudt.
}
\references{
Ardia, D., Boudt, K. (2015).  
Testing equality of modified Sharpe ratios.
\emph{Finance Research Letters} \bold{13}, pp.97--104. 
\doi{10.1016/j.frl.2015.02.008}

Ardia, D., Boudt, K. (2016).  
The Peer Ratios Performance of Hedge Funds. 
\emph{Working paper}.
\doi{10.2139/ssrn.2000901}

Barras, L., Scaillet, O., Wermers, R. (2010).  
False discoveries in mutual fund performance: Measuring luck in estimated alphas.  
\emph{Journal of Finance} \bold{65}(1), pp.179--216.
\doi{10.1111/j.1540-6261.2009.01527.x}

Carhart, M. (1997).  
On persistence in mutual fund performance.
\emph{Journal of Finance} \bold{52}(1), pp.57--82.
\doi{10.1111/j.1540-6261.1997.tb03808.x}

Fama, E., French, K. (2010).  
Luck versus skill in the cross-section of mutual fund returns.  
\emph{Journal of Finance} \bold{65}(5), pp.1915--1947.
\doi{10.1111/j.1540-6261.2010.01598.x}

Fung, W., Hsieh, D. (2004).  
Hedge fund benchmarks: A risk based approach.
\emph{Financial Analysts Journal} \bold{60}(5), pp.65--80.
\doi{10.2469/faj.v60.n5.2657}

Storey, J. (2002).  
A direct approach to false discovery rates.
\emph{Journal of the Royal Statistical Society B} \bold{64}(3), pp.479--498.
\doi{10.1111/1467-9868.00346}

Treynor, J. L., Black, F. (1973).  
How to use security analysis to improve portfolio selection.  
\emph{Journal of Business} \bold{46}(1), pp.66--86.
\doi{10.1002/9781119196679.ch60}
}
\seealso{
\code{\link{sharpeScreening}} and \code{\link{msharpeScreening}}.
}
\keyword{htest}

