% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EvaluatePlp.R
\name{modelBasedConcordance}
\alias{modelBasedConcordance}
\title{Calculate the model-based concordance, which is a calculation of the expected
discrimination performance of a model under the assumption the model predicts
the "TRUE" outcome as detailed in van Klaveren et al.
https://pubmed.ncbi.nlm.nih.gov/27251001/}
\usage{
modelBasedConcordance(prediction)
}
\arguments{
\item{prediction}{the prediction object found in the plpResult object}
}
\value{
The model-based concordance value
}
\description{
Calculate the model-based concordance, which is a calculation of the expected
discrimination performance of a model under the assumption the model predicts
the "TRUE" outcome as detailed in van Klaveren et al.
https://pubmed.ncbi.nlm.nih.gov/27251001/
}
\details{
Calculate the model-based concordance
}
\examples{
prediction <- data.frame(value = runif(100))
modelBasedConcordance(prediction)
}
