% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paris2024_palette.R
\name{paris2024_palette}
\alias{paris2024_palette}
\title{Paris 2024 palette generator}
\usage{
paris2024_palette(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of the colour palette. Options are \code{Logo},
\code{OlympicRings}, \code{GamesLook}.}

\item{n}{Number of colours in the palette. Palettes have 2 to 5 colours that
can be used as a discrete palette. To use more, use a continuous palette.}

\item{type}{Usage of palette as "continuous" or "discrete". Continuous usage
interpolates between colors to create a scale of values. If omitted, function
assumes continuous if n > length of palette, and discrete if n < length of
palette.}
}
\value{
A vector of colours.
}
\description{
Paris 2024 palette generator
}
\examples{
paris2024_palette("GamesLook", n = 6, type = "continuous")
paris2024_palette("Logo", 2)
paris2024_palette("OlympicRings")
}
