% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{Pareto_Find_Alpha_btw_FQ_Layer}
\alias{Pareto_Find_Alpha_btw_FQ_Layer}
\title{Pareto Alpha Between a Frequency and a Layer}
\usage{
Pareto_Find_Alpha_btw_FQ_Layer(
  Threshold,
  Frequency,
  Cover,
  AttachmentPoint,
  ExpLoss,
  max_alpha = 100,
  tolerance = 1e-10,
  truncation = NULL
)
}
\arguments{
\item{Threshold}{Numeric. Threshold}

\item{Frequency}{Numeric. Expected frequency in excess of \code{Thershold}}

\item{Cover}{Numeric. Cover of the second layer.}

\item{AttachmentPoint}{Numeric. Attachment point of the layer.}

\item{ExpLoss}{Numeric. Expected loss of the layer.}

\item{max_alpha}{Numeric. Upper limit for the alpha that is returned.}

\item{tolerance}{Numeric. Accuracy of the result.}

\item{truncation}{Numeric. If \code{truncation} is not \code{NULL} then the Pareto distribution is truncated at \code{truncation}.}
}
\value{
The Pareto alpha between the expected number of claims \code{Frequency} excess \code{Threshold}
and the layer  \code{Cover} xs \code{AttachmentPoint} with expected loss \code{ExpLoss}
}
\description{
Finds the Pareto alpha between an excess frequency and the expected loss of a layer
}
\examples{
Pareto_Find_Alpha_btw_FQ_Layer(1000, 1, 1000, 1000, 500)
Pareto_Find_Alpha_btw_FQ_Layer(1000, 1, 1000, 1000, 500, truncation = 5000)

}
\references{
Riegel, U. (2018) Matching tower information with piecewise Pareto. European Actuarial Journal 8(2): 437--460
}
