context("paramValueToString")


test_that("paramValueToString ", {
  u = makeNumericParam("u")
  v = makeIntegerVectorParam("v", length=2)
  w = makeDiscreteParam("w", values=list(a=1, b=list()))
  x = makeLogicalParam("x")
  y = makeDiscreteVectorParam("y", length=2, values=list(a=1, b=list()))

  ps = makeParamSet(u, v, w, x, y)
  expect_equal(paramValueToString(u, 1), "1.00")
  expect_equal(paramValueToString(u, 1.2345), "1.23")
  expect_equal(paramValueToString(v, c(1, 2)), "1,2")
  expect_equal(paramValueToString(w, 1), "a")
  expect_equal(paramValueToString(w, list()), "b")
  expect_equal(paramValueToString(x, TRUE), "TRUE")
  expect_equal(paramValueToString(y, list(1, 1)), "a,a")
  expect_equal(paramValueToString(y, list(1, list())), "a,b")
  expect_equal(paramValueToString(ps, list(1, 1:2, list(), FALSE, list(1,list()))), "u=1.00,v=1,2,w=b,x=FALSE,y=a,b")
})