#' Print method for \code{plottedPandemic} objects
#'
#' The print method for a \code{plottedPandemic} S3 class object displays the single plot or both
#' separated by a prompt for the user.
#'
#' @method print plottedPandemic
#' @param x An object of S3 class \code{\link{plottedPandemic-objects}}.
#' @param ... Currently unused.
#' @return Returns \code{x}, invisibly.
#' @details
#' The plots generated by \code{\link{plot.pandemicPredicted}} are displayed by this function
#' If only one of the plots has been generated via the argument \code{term}, then it is displayed
#' in the Viewer windows as an html object, produced by the \code{\link[plotly]{plot_ly}} function.
#' If both long term and short term plots are requested, then the long term plot is displayed first
#' and a message prompts the user to display the next plot, namely the short term one.
#'
#' @seealso \code{\link{posterior_predict.pandemicEstimated}} and \code{\link{plot.pandemicPredicted}}
#' @export
print.plottedPandemic = function(x, ...){
  if (!is(x, "plottedPandemic")) stop("Please use the output of the plot.pandemicPredicted method()")

  plotLong = !is.null(x$long)
  plotShort = !is.null(x$short)
  if (!any(plotLong,plotShort)) stop("No plots found.")

  if (plotLong & plotShort){
    print(x$long)
    cat("\nHit <Return> to see next plot: ")
    line <- readline()
    print(x$short)
    } else if (plotLong) print(x$long) else print(x$short)

  invisible(x)
}
