% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addEsriAddress.R
\name{addEsriAddress}
\alias{addEsriAddress}
\title{Add address information to a dataframe}
\usage{
addEsriAddress(df, lonVar = "longitude", latVar = "latitude",
  existingMeta = NULL)
}
\arguments{
\item{df}{dataframe with geolocation information (\emph{e.g.} those created by \code{wrcc_qualityControl()} or \code{airsis_qualityControl})}

\item{lonVar}{name of longitude variable in the incoming dataframe}

\item{latVar}{name of the latitude variable in the incoming dataframe}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}
}
\value{
Input dataframe with additional columns: \code{siteName, countyName}.
}
\description{
ESRI APIs are used to determine
address information associated with the locations specified by the
\code{longitude} and \code{latitude} columns of the incoming dataframe.
}
\examples{
\dontrun{
df <- data.frame(longitude=c(-121,-122,-123),latitude=c(42,43,44))
addEsriAddress(df)
}
}
\references{
\url{https://developers.arcgis.com/rest/geocode/api-reference/geocoding-reverse-geocode.htm}
}
\keyword{internal}
