% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitorLeaflet.R
\name{monitorLeaflet}
\alias{monitorLeaflet}
\title{Leaflet Interactive Map of Monitoring Stations}
\usage{
monitorLeaflet(ws_monitor, slice = get("max"), breaks = AQI$breaks_24,
  colors = AQI$colors, labels = AQI$names, legendTitle = "Max AQI Level",
  radius = 10, opacity = 0.7, maptype = "terrain",
  popupInfo = c("siteName", "monitorID", "elevation"))
}
\arguments{
\item{ws_monitor}{ws_monitor object}

\item{slice}{either a time index or a function used to collapse the time axis -- defautls to \code{get('max')}}

\item{breaks}{set of breaks used to assign colors}

\item{colors}{a set of colors for different levels of air quality data determined by \code{breaks}}

\item{labels}{a set of text labels, one for each color}

\item{legendTitle}{legend title}

\item{radius}{radius of monitor circles}

\item{opacity}{opacity of monitor circles}

\item{maptype}{optional name of leaflet ProviderTiles to use, e.g. "terrain"}

\item{popupInfo}{a vector of column names from ws_monitor$meta to be shown in a popup window}
}
\value{
Initiates the interactive leaflet plot in Rstudio's 'Viewer' tab.
}
\description{
This function creates interactive maps that will be displayed in RStudio's 'Viewer' tab.
The \code{slice} argument is used to collapse a \emph{ws_monitor} timeseries into a single value.
If \code{slice} is an integer, that row index will be selected from the \code{ws_monitor$data} dataframe.
If \code{slice} is a function (unquoted), that function will be applied to the timeseires with the
argument \code{na.rm=TRUE} (e.g. \code{max(..., na.rm=TRUE)}).

If \code{slice} is a user defined function it will be used with argument \code{na.rm=TRUE} to
collapse the time dimension. Thus, user defined functions must accept \code{na.rm} as an argument.
}
\details{
The \code{maptype} argument is mapped onto leaflet "ProviderTile" names. Current mappings include:
\enumerate{
\item{"roadmap"}{ -- "OpenStreetMap"}
\item{"satellite"}{ -- "Esri.WorldImagery"}
\item{"terrain"}{ -- ""Esri.WorldTopoMap"}
\item{"toner"}{ -- "Stamen.Toner"}
}

If a character string not listed above is provided, it will be used as the underlying map tile if available.
See \url{https://leaflet-extras.github.io/leaflet-providers/} for a list of "provider tiles"
to use as the background map.
}
\examples{
\dontrun{
airnow <- airnow_load(20140913, 20141010)
v_low <- AQI$breaks_24[4] 
CA_unhealthy_monitors <- monitor_subset(airnow, stateCodes='CA', vlim=c(v_low, Inf))
monitorLeaflet(CA_unhealthy_monitors, maptype="toner")
}
}
\keyword{ws_monitor}
