% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rawPlot_windRose.R
\name{rawPlot_windRose}
\alias{rawPlot_windRose}
\title{Create Wind Rose Plot from a Raw Dataframe}
\usage{
rawPlot_windRose(df, tlim = NULL, localTime = TRUE, ...)
}
\arguments{
\item{df}{enhanced, raw dataframe as created by the \code{raw_enhance()} function}

\item{tlim}{optional vector with start and end times (integer or character representing YYYYMMDD[HH])}

\item{localTime}{logical specifying whether \code{tlim} is in local time or UTC}

\item{...}{additional arguments to pass on to \code{openair::windRose()}}
}
\description{
Create wind rose plot from raw_enhance object. Based on openair::windRose().
}
\note{
If more than one timezone is found, \code{localTime} is ignored and UTC is used.
}
\examples{
\dontrun{
raw <- airsis_createRawDataframe(20160901, 20161015, provider='USFS', unitID=1012)
raw <- raw_enhance(raw, rawSource='AIRSIS')
rawPlot_windRose(raw)
}
}
\keyword{raw}

