% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-code.R
\name{alphahat_LR_one_Rcpp}
\alias{alphahat_LR_one_Rcpp}
\title{Estimates PWD Parameter alpha by Maximum Marginal Predictive Likelihood}
\usage{
alphahat_LR_one_Rcpp(y, X = FALSE, alpha.grid = seq(0.65, 1, length.out =
  150), init = 2, plotting = TRUE)
}
\arguments{
\item{y}{T-length time series vector.  y[1] represents the beginning of
the time eries.}

\item{X}{[T x p] dimensional matrix of covariates. This should not 
include the intercept column. If X is FALSE, intercept model is run.}

\item{alpha.grid}{Grid of alpha values over which to compute the marginal
predictive likelihood.}

\item{init}{integer representing the time point to begin computing marginal
predictive likelihoods.}

\item{plotting}{If TRUE, plot the marginal predictive distribution of alpha.}
}
\value{
Return a scalar value representing the value of alpha which maximizes
the marginal predictive likelihood of the data over the grid of alpha values
considered.
}
\description{
This is the main function of the package.  It takes as inputs the 
time series data as response, as well as a predictor matrix, excluding 
the intercept column, and other settings. It returns as outputs a 
scalar representing the value of alpha which maximizes the marginal 
predictive likelihood of the data given the grid of alpha values 
considered.
}
\examples{
set.seed(12)
N=80
err = rnorm(N)
X = 1:N
slopes = c(rep(1.5,40),rep(2,N-40))
y = rep(5,N) + slopes*X + err
init=6                
alpha.grid = seq(.75,1,length.out=40)
alphahat=alphahat_LR_one_Rcpp(y=y,X=X,alpha.grid=alpha.grid,init=init,plotting=TRUE)
alpha1 = 1.0
coeffs1 = bhat.func(y,X,alpha1)
alpha2 = alphahat
coeffs2 = bhat.func(y,X,alpha2)
plot(x=X,y=y)
abline(a=coeffs2[1],b=coeffs2[2],lty=2,col="red")
abline(a=coeffs1[1],b=coeffs1[2],lty=2)
legend("right", legend=c("OLS","PWD"), col=c(1,2), lty=c(2,2), lwd=c(1,1))
}

