% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dubininradushkevishnlanalysis.R
\name{dubininradanalysis}
\alias{dubininradanalysis}
\title{Dubinin-Radushkevich Isotherm Analysis Non-Linear Form}
\usage{
dubininradanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the linear regression, errors, and the parameter values (Xm, and K) for the Dubinin-Radushkevich Isotherm Model
}
\description{
It is an empirical generally applied to express adsorption mechanism with Gaussian energy distribution onto heterogeneous surfaces (Tsamo, et,al, 2019). In the non-linear form, qe =Xm*exp(-K*Ce^2). The said model has often fitted high solute activities and the intermediate range of concentrations as well. One unique feature of the said model is that it is temperature-dependent (Dada, et, al, 2012).
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
dubininradanalysis(Ce, Qe)
}
\references{
One-, Two-, and Three-Parameter Isotherms, Kinetics, and Thermodynamic Evaluation of Co(II) Removal from Aqueous Solution Using Dead Neem Leaves, Tsamo, et,al. (2019), Volume 2019, https://doi.org/10.1155/2019/6452672

Langmuir, Freundlich, Temkin, and Dubinin-Radushkevich Isotherms Studies of Equilibrium Sorption of Zn^+2 Unto Phosphoric Acid Modified Rise Husk, Dada, et, al, (2012), Journal of Applied Chemistry, Volume 3, Issue 1, pp 38-45, www.iosrjournals.org
}
\author{
Morales, Dale Jonathan, M.

C.C. Deocaris
}
