% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/A01-estimator-weibull.R
\name{var_surv_weibull_analytical}
\alias{var_surv_weibull_analytical}
\title{Compute Analytical M-Estimation Variance for Binary Treatment Survival Functions}
\usage{
var_surv_weibull_analytical(surv_result)
}
\arguments{
\item{surv_result}{Output from \code{surv_weibull()} with binary treatment (2 levels).}
}
\value{
List containing:
  \item{var_matrix}{Matrix [time x 3] of variances: [var(S0), var(S1), var(S1-S0)].}
  \item{se_matrix}{Matrix [time x 3] of standard errors: [se(S0), se(S1), se(S1-S0)].}
  \item{influence_components}{List of Itheta and Igamma arrays for delta variance.}
  \item{Etau}{Normalization constant.}
  \item{n}{Sample size after trimming.}
}
\description{
Computes analytical variance estimates using M-estimation for binary treatment.
Calculates variances for S^(0)(t), S^(1)(t), and their difference S^(1)(t) - S^(0)(t).
}
\details{
Implements M-estimation variance for binary treatment survival functions.
For each group j: \deqn{I_j = \frac{1}{E_\tau}(I_{\tau,j} + I_{\theta_j} + I_{\gamma_j} + I_{\beta,j})}
\deqn{Var(S^{(j)}) = \sum I_j^2 / n^2}

For the difference: \deqn{I_{diff} = \frac{1}{E_\tau}(I_{\tau,diff} + I_{\theta_1} - I_{\theta_0} + I_{\gamma_1} - I_{\gamma_0} + I_{\beta,diff})}
\deqn{Var(S^{(1)} - S^{(0)}) = \sum I_{diff}^2 / n^2}
}
\keyword{internal}
