% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PSTR.R
\docType{package}
\name{PSTR}
\alias{PSTR}
\alias{PSTR-package}
\title{PSTR: A package implementing the Panel Smooth Transition Regression (PSTR) modelling.}
\description{
The package implements the Panel Smooth Transition Regression (PSTR) modelling.
}
\details{
The modelling procedure consists of three stages: Specification, Estimation and Evaluation.
The package offers tools helping the package users to conduct model specification tests,
to do PSTR model estimation, and to do model evaluation.

The cluster-dependency and heteroskedasticity-consistent tests are implemented in the package.

The wild bootstrap and cluster wild bootstrap tests are also implemented.

Parallel computation (as an option) is implemented in some functions, especially the bootstrap tests.
Therefore, the package suits tasks running many cores on super-computation servers.

The Panel Smooth Transition Regression (PSTR) model is defined to be
\deqn{y_{it} = \mu_i + \beta_0' x_{it} + \beta_1' z_{it} g_{it} + u_{it}}
where \eqn{g_{it}} is the transition function taking the logistic form with the transition variable for individual \eqn{i}, \eqn{x_{it}} contains the explanatory variables in the linear part, and \eqn{z_{it}} contains the explanatory variables in the nonlinear part, and they can be different.
}
\section{Author and Maintainer}{

Yukai Yang

Department of Statistics, Uppsala University

\email{yukai.yang@statistik.uu.se}
}

\section{References}{

González, A., Teräsvirta, T., van Dijk, D. and Yang, Y. (2017) \emph{Panel Smooth Transition Regression Models}
}

\section{Function for Initialization}{

\code{\link{NewPSTR}} initialize the modelling by creating an object of the class PSTR.
}

\section{Functions for Model Specification}{

\code{\link{LinTest}} implements the linearity tests.

\code{\link{WCB_LinTest}} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) linearity tests.
}

\section{Function for Model Estimation}{

\code{\link{EstPSTR}} implements the estimation of the PSTR model.
}

\section{Functions for Model Evaluation}{

\code{\link{EvalTest}} implements the evaluation tests.

\code{\link{WCB_TVTest}} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) evaluation test of no time-varying parameters.

\code{\link{WCB_HETest}} implements the wild bootstrap (WB) and the wild cluster bootstrap (WCB) evaluation test of no remaining nonlinearity (no remaining heterogeneity).
}

\section{Other Functions}{

\code{\link{version}} shows the version number and some information of the package.

\code{\link{print.PSTR}} prints the object of the class PSTR.
}

