% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{PPQ.occurve}
\alias{PPQ.occurve}
\title{Operating Characteristic (OC) Curves for the CQA PPQ Plan Using General Multiplier.}
\usage{
PPQ.occurve(attr.name, attr.unit, Llim, Ulim, mu, sigma, n, n.batch, k, add.reference)
}
\arguments{
\item{attr.name}{(optional) user-defined attribute name}

\item{attr.unit}{(optional) user-defined attribute unit}

\item{Llim}{lower specification limit}

\item{Ulim}{upper specification limit}

\item{mu}{hypothetical mean of the attribute}

\item{sigma}{hypothetical standard deviation of the attribute}

\item{n}{sample size (number of locations) per batch}

\item{n.batch}{number of batches for passing PPQ during validation}

\item{k}{general mulipler for constructing the specific interval}

\item{add.reference}{logical; if \code{TRUE}, then add reference OC curves (Baseline and High Performance) in the plot.}
}
\value{
OC curves for specification test and PPQ plan.
}
\description{
The function for  plotting the OC curve to show the PPQ plan, given lower and upper specification limits.
}
\examples{
\dontrun{
PPQ.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%", Llim=95, Ulim=105,
mu=97, sigma=seq(0.1, 10, 0.1), n=10, k=2.373, add.reference=TRUE)
PPQ.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%", Llim=95, Ulim=105,
mu=100, sigma=seq(0.1, 10, 0.1), n=10, k=2.373, add.reference=TRUE)
PPQ.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%", Llim=95, Ulim=105,
mu=seq(95,105,0.1), sigma=1, n=10, k=2.373)
PPQ.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%", Llim=95, Ulim=105,
mu=seq(95,105,0.1), sigma=1, n=10, k=2.373, add.reference=TRUE)

PPQ.occurve(attr.name = "Protein Concentration", attr.unit="\%", Llim=90, Ulim=110,
mu=seq(90, 110, 0.1), sigma=1.25, k=2.373)

## Only display referece curves, leave k as NULL by default
PPQ.occurve(attr.name = "Sterile Concentration Assay", attr.unit="\%LC", Llim=95, Ulim=105, 
mu=98, sigma=seq(0.1, 10, 0.1), n=10, add.reference=TRUE)
}
}
\references{
Burdick, R. K., LeBlond, D. J., Pfahler, L. B., Quiroz, J., Sidor, L., Vukovinsky, K., & Zhang, L. (2017).
Statistical Applications for Chemistry, Manufacturing and Controls (CMC) in the Pharmaceutical Industry.
\emph{Springer}.
}
\seealso{
\code{PPQ.pp} and \code{rl.pp}.
}
\author{
Yalin Zhu

Yalin Zhu
}
