% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flignerWolfeTest.R
\name{flignerWolfeTest}
\alias{flignerWolfeTest}
\alias{flignerWolfeTest.default}
\alias{flignerWolfeTest.formula}
\title{Testing Several Treatments With One Control}
\usage{
flignerWolfeTest(x, ...)

\method{flignerWolfeTest}{default}(
  x,
  g,
  alternative = c("greater", "less"),
  dist = c("Wilcoxon", "Normal"),
  ...
)

\method{flignerWolfeTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("greater", "less"),
  dist = c("Wilcoxon", "Normal"),
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{"greater"}.}

\item{dist}{the test distribution. Defaults to \code{"Wilcoxon"}.}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{the estimated quantile of the test statistic.}
\item{p.value}{the p-value for the test.}
\item{parameter}{the parameters of the test statistic, if any.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Fligner-Wolfe non-parametric test for
simultaneous testing of several locations of treatment groups
against the location of the control group.
}
\details{
For a one-factorial layout with non-normally distributed residuals
the Fligner-Wolfe test can be used.

Let there be \eqn{k-1}-treatment groups and one control group, then
the null hypothesis, H\eqn{_0: \theta_i - \theta_c = 0 ~ (1 \le i \le k-1)}
is tested against the alternative (greater),
A\eqn{_1: \theta_i - \theta_c > 0 ~ (1 \le i \le k-1)},
with at least one inequality being strict.

Let \eqn{n_c} denote the sample size of the control group,
\eqn{N^t = \sum_{i=1}^{k-1} n_i} the sum of all treatment
sample sizes and \eqn{N = N^t + n_c}. The test statistic without taken
ties into account is

\deqn{
 W = \sum_{j=1}^{k-1} \sum_{i=1}^{n_i} r_{ij} -
 \frac{N^t \left(N^t + 1 \right) }{2}
}{%
 SEE PDF
}

with \eqn{r_{ij}} the rank of variable \eqn{x_{ij}}.
The null hypothesis is rejected,
if \eqn{W > W_{\alpha,m,n}} with
\eqn{m = N^t} and \eqn{n = n_c}.

In the presence of ties, the statistic is

\deqn{
    \hat{z} = \frac{W - n_c N^t / 2}{s_W},
 }{%
  SEE PDF
 }

where
\deqn{ s_W =
  \frac{n_c N^t}{12 N \left(N - 1 \right)}
  \sum_{j=1}^g t_j \left(t_j^2 - 1\right),
}{%
 SEE PDF
}

with \eqn{g} the number of tied groups and \eqn{t_j}
the number of tied values in the \eqn{j}th group. The null hypothesis
is rejected, if \eqn{\hat{z} > z_\alpha} (as cited in EPA 2006).

If \code{dist = Wilcoxon}, then the \eqn{p}-values are estimated from the  \code{\link[stats]{Wilcoxon}}
distribution, else the \code{\link[stats]{Normal}} distribution is used. The latter can be used,
if ties are present.
}
\note{
Factor labels for \code{g} must be assigned in such a way,
that they can be increasingly ordered from zero-dose
control to the highest dose level, e.g. integers
\{0, 1, 2, ..., k\} or letters \{a, b, c, ...\}.
Otherwise the function may not select the correct values
for intended zero-dose control.

It is safer, to i) label the factor levels as given above,
and to ii) sort the data according to increasing dose-levels
prior to call the function (see \code{\link{order}}, \code{\link{factor}}).
}
\examples{
## Example from Sachs (1997, p. 402)
x <- c(106, 114, 116, 127, 145,
       110, 125, 143, 148, 151,
       136, 139, 149, 160, 174)
g <- gl(3,5)
levels(g) <- c("A", "B", "C")

## Chacko's test
chackoTest(x, g)

## Cuzick's test
cuzickTest(x, g)

## Johnson-Mehrotra test
johnsonTest(x, g)

## Jonckheere-Terpstra test
jonckheereTest(x, g)

## Le's test
leTest(x, g)

## Spearman type test
spearmanTest(x, g)

## Murakami's BWS trend test
bwsTrendTest(x, g)

## Fligner-Wolfe test
flignerWolfeTest(x, g)

## Shan-Young-Kang test
shanTest(x, g)

}
\references{
EPA (2006) \emph{Data Quality Assessment:
Statistical Methods for Practitioners}
(Guideline No. EPA QA/G-9S), US-EPA.

Fligner, M.A., Wolfe, D.A. (1982)
Distribution-free tests for comparing several
treatments with a control. \emph{Stat Neerl} \bold{36},
119--127.
}
\seealso{
\code{\link{kruskalTest}} and \code{\link{shirleyWilliamsTest}}
of the package \pkg{PMCMRplus},
\code{\link[stats]{kruskal.test}} of the library \pkg{stats}.
}
\concept{trendtest}
\concept{wilcoxonranks}
\keyword{htest}
\keyword{nonparametric}
