% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLMIXfunctions.R
\name{make_partial}
\alias{make_partial}
\title{Censoring of complete rankings/orderings}
\usage{
make_partial(data, format = c("ordering", "ranking"), nranked = NULL,
  probcensoring = rep(1, K - 1))
}
\arguments{
\item{data}{Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of complete sequences.}

\item{format}{Character string indicating the format of the \code{data} argument.}

\item{nranked}{Numeric vector of length \eqn{N} with the desired number of items ranked by each sample unit after censoring. If not supplied (\code{NULL}), the censoring patterns are randomly generated according to the probabilities in the \code{probcensoring} argument.}

\item{probcensoring}{Numeric vector of length \eqn{(K-1)} with the probability of each censoring pattern to be employed for the random truncation of the complete sequences. It works only if \code{nranked} argument is \code{NULL}. See Details for further explanation. Default is equal probabilities.}
}
\value{
A list of two named objects:

 \item{\code{partialdata}}{ Numeric \eqn{N}\eqn{\times}{x}\eqn{K} data matrix of partial (censored) sequences.}	
 \item{\code{nranked}}{ Numeric vector of length \eqn{N} with the number of items ranked by each sample unit after censoring.}
}
\description{
Return partial top rankings/orderings from complete sequences obtained either with user-specified censoring patterns or with a random truncation.
}
\details{
The censoring of the complete sequences in the \code{data} argument can be performed in: (i) a deterministic way, by specifying the number of top positions to be retained for each sample unit in the \code{nranked} argument; (ii) a random way, by sequentially specifying the probabilities of the top-1, top-2,...,top-\eqn{(K-1)} censoring patterns in the \code{probcensoring} argument. Recall that a top-\eqn{(K-1)} sequence corresponds to a complete ordering/ranking. The returned \code{partialdata} matrix has the same format of the input \code{data} with missing positions denoted with zero entries.
}
\examples{

library(PLMIX)
data(d_german)
N <- nrow(d_german)
head(d_german)
set.seed(57524)
d_german_censored <- make_partial(data=d_german, format="ordering", 
                                  probcensoring=c(0.3, 0.3, 0.4))  
head(d_german_censored$partialdata)
round(table(d_german_censored$nranked)/N, 2)
}
\author{
Cristina Mollica and Luca Tardella
}
\references{
Mollica, C., Tardella, L. (2016). Bayesian Plackett-Luce mixture models for partially ranked data. \emph{Psychometrika} (published online), DOI: 10.1007/s11336-016-9530-0.
}

