% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{PKNCA_impute_method}
\alias{PKNCA_impute_method}
\alias{PKNCA_impute_method_start_conc0}
\alias{PKNCA_impute_method_start_cmin}
\alias{PKNCA_impute_method_start_predose}
\title{Methods for imputation of data with PKNCA}
\usage{
PKNCA_impute_method_start_conc0(conc, time, start = 0, ..., options = list())

PKNCA_impute_method_start_cmin(conc, time, start, end, ..., options = list())

PKNCA_impute_method_start_predose(
  conc,
  time,
  start,
  end,
  conc.group,
  time.group,
  ...,
  max_shift = NA_real_,
  options = list()
)
}
\arguments{
\item{conc}{Measured concentrations}

\item{time}{Time of the measurement of the concentrations}

\item{start}{The start time of the interval}

\item{...}{ignored}

\item{options}{List of changes to the default PKNCA options (see
\code{PKNCA.options()})}

\item{end}{The end time of the interval}

\item{conc.group}{All concentrations measured for the group}

\item{time.group}{Time of all concentrations measured for the group}

\item{max_shift}{The maximum amount of time to shift a concentration forward
(defaults to 5\% of the interval duration, i.e. \code{0.05*(end - start)}, if
\code{is.finite(end)}, and when \code{is.infinite(end)}, defaults to 5\% of the time
from start to \code{max(time)})}
}
\value{
A data.frame with one column named conc with imputed concentrations
and one column named time with the times.
}
\description{
Methods for imputation of data with PKNCA
}
\section{Functions}{
\itemize{
\item \code{PKNCA_impute_method_start_conc0()}: Add a new concentration of 0 at the start
time, even if a nonzero concentration exists at that time (usually used
with single-dose data)

\item \code{PKNCA_impute_method_start_cmin()}: Add a new concentration of the minimum during
the interval at the start time (usually used with multiple-dose data)

\item \code{PKNCA_impute_method_start_predose()}: Shift a predose concentration to become the
time zero concentration (only if a time zero concentration does not exist)

}}
