% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.functions.R
\name{check.conc.time}
\alias{check.conc.time}
\title{Verify that the concentration and time are valid}
\usage{
check.conc.time(conc, time, monotonic.time = TRUE)
}
\arguments{
\item{conc}{Measured concentrations}

\item{time}{Time of the measurement of the concentrations}

\item{monotonic.time}{Must the time be unique and monotonically
increasing?}
}
\value{
None
}
\description{
If the concentrations or times are invalid, will provide an error.
Reasons for being invalid are
\itemize{
  \item \code{time} is not a number
  \item \code{conc} is not a number
  \item Any \code{time} value is NA
  \item \code{time} is not monotonically increasing
  \item \code{conc} and \code{time} are not the same length
}
}
\details{
Some cases may generate warnings but allow the data to proceed.
\itemize{
  \item A negative concentration is often but not always an
    error; it will generate a warning.
}
}
