% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-PKNCAdose.R
\name{PKNCAdose}
\alias{PKNCAdose}
\alias{PKNCAdose.default}
\alias{PKNCAdose.tbl_df}
\alias{PKNCAdose.data.frame}
\title{Create a PKNCAdose object}
\usage{
PKNCAdose(data, ...)

\method{PKNCAdose}{default}(data, ...)

\method{PKNCAdose}{tbl_df}(data, ...)

\method{PKNCAdose}{data.frame}(data, formula, route, rate, duration, time.nominal, exclude, ...)
}
\arguments{
\item{data}{A data frame with time and the groups defined in
\code{formula}.}

\item{...}{Ignored.}

\item{formula}{The formula defining the
\code{dose.amount~time|groups} where \code{time} is the time of the
dosing and \code{dose.amount} is the amount administered at that
time (see Details).}

\item{route}{Define the route of administration.  The value may be
either a column name from the \code{data} (checked first) or a
character string of either \code{"extravascular"} or
\code{"intravascular"} (checked second).  If given as a column
name, then every value of the column must be either
\code{"extravascular"} or \code{"intravascular"}.}

\item{rate, duration}{(optional) for \code{"intravascular"} dosing,
the rate or duration of dosing.  If given as a character string, it
is the name of a column from the \code{data}, and if given as a
number, it is the value for all doses.  Only one may be given, and
if neither is given, then the dose is assumed to be a bolus
(\code{duration=0}).  If \code{rate} is given, then the dose amount
must be given (the left hand side of the \code{formula}).}

\item{time.nominal}{(optional) The name of the nominal time column
(if the main time variable is actual time.  The \code{time.nominal}
is not used during calculations; it is available to assist with
data summary and checking.}

\item{exclude}{(optional) The name of a column with concentrations to
exclude from calculations and summarization.  If given, the column
should have values of \code{NA} or \code{""} for concentrations to
include and non-empty text for concentrations to exclude.}
}
\value{
A PKNCAconc object that can be used for automated NCA.
}
\description{
Create a PKNCAdose object
}
\details{
The \code{formula} for a \code{PKNCAdose} object can be
  given three ways: one-sided (missing left side), one-sided (missing
  right side), or two-sided.  Each of the three ways can be given
  with or without groups.  When given one-sided missing the left
  side, the left side can either be omitted or can be given as a
  period (\code{.}): \code{~time|treatment+subject} and
  \code{.~time|treatment+subject} are identical, and dose-related NCA
  parameters will all be reported as not calculable (for example,
  clearance).  When given one-sided missing the right side, the right
  side must be specified as a period (\code{.}):
  \code{dose~.|treatment+subject}, and only a single row may be given
  per group.  When the right side is missing, PKNCA assumes that the
  same dose is given in every interval.  When given as a two-sided
  formula
}
\seealso{
Other PKNCA objects: 
\code{\link{PKNCAconc}()},
\code{\link{PKNCAdata}()},
\code{\link{PKNCAresults}()}
}
\concept{PKNCA objects}
