% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngr.R
\name{ngr}
\alias{ngr}
\title{Nested Group Bridge Regression Model}
\usage{
ngr(
  Y,
  X,
  M,
  d,
  domain,
  extra = list(alphaPS = exp(seq(-20, 20, len = 20)), kappa = exp(seq(-10, 10, len = 8)),
    tau = exp(seq(-50, -10, len = 8)), gamma = 0.5, niter = 100)
)
}
\arguments{
\item{Y}{Vector of length n.}

\item{X}{Matrix of n x p, covariate matrix, should be dense.}

\item{M}{Integer, t1,..., tM are M equally spaced knots.}

\item{d}{Integer, the degree of B-Splines.}

\item{domain}{The range over which the function X(t) is evaluated and the coefficient function \eqn{\beta}(t) is expanded by the B-spline basis functions.}

\item{extra}{List containing other parameters which have defaults:
\itemize{
  \item alphaPs: Smoothing parameter for the Penalized B-splines method, default is exp(seq(-20,20,len = 20)).
  \item kappa: Tuning parameter for roughness penalty, default is exp(seq(-10,10,len = 8)).
  \item tau: Tuning parameter for the group bridge penalty, default is exp(seq(-50,-10,len = 8)).
  \item gamma: Real number, default is 0.5.
  \item niter: Integer, maximum number of iterations, default is 100.
}}
}
\value{
beta: Estimated \eqn{\beta}(t) at discrete points.

extra: List containing other values which may be of use:
       \itemize{
         \item b: Estimated b-hat.
         \item delta: Estimated cutoff point.
         \item Ymean: Estimated y-hat.
         \item Xmean: Estimated x-hat.
         \item Optkappa: Optimal roughness penalty selected.
         \item Opttau: Optimal group bridge penalty selected.
         \item M: Integer representing the number of knots used in the model calculation.
         \item d: Integer, degree of B-Splines used.
         \item domain: The range over which the function X(t) was evaluated and the coefficient function \eqn{\beta}(t) was expanded by the B-spline basis functions.
       }
}
\description{
Calculates a functional regression model using a nested group bridge approach.
}
\examples{
library(fda)
betaind = 1
snr  = 2
nsim = 1
n    = 50
p    = 21
Y = array(NA,c(n,nsim))
X = array(NA,c(n,p,nsim))
domain = c(0,1)

M = 20
d = 3
norder   = d+1
nknots   = M+1
tobs = seq(domain[1],domain[2],length.out = p)
knots    = seq(domain[1],domain[2],length.out = nknots)
nbasis   = nknots + norder - 2
basis    = create.bspline.basis(knots,nbasis,norder)
basismat = eval.basis(tobs, basis)
h = (domain[2]-domain[1])/M
cef = c(1, rep(c(4,2), (M-2)/2), 4, 1)

V = eval.penalty(basis,int2Lfd(2))
alphaPS = 10^(-(10:3))
kappa   = 10^(-(8:7))
tau     = exp(seq(-35,-28,len=20))
gamma   = 0.5


for(itersim in 1:nsim)
{
dat = ngr.data.generator.bsplines(n=n,nknots=64,norder=4,p=p,domain=domain,snr=snr,betaind=betaind)
Y[,itersim]  = dat$Y
X[,,itersim] = dat$X
}

ngrfit = ngr(Y=Y[1:n,1],X=(X[1:n,,1]),M,d,domain,extra= list(alphaPS=alphaPS, kappa=kappa, tau=tau))

}
